"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubFeaturePrivilegeGroup = void 0;
var _sub_feature_privilege = require("./sub_feature_privilege");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SubFeaturePrivilegeGroup {
  constructor(config, actionMapping = {}) {
    this.config = config;
    this.actionMapping = actionMapping;
  }
  get groupType() {
    return this.config.groupType;
  }
  get privileges() {
    return this.config.privileges.map(p => new _sub_feature_privilege.SubFeaturePrivilege(p, this.actionMapping[p.id] || []));
  }
}
exports.SubFeaturePrivilegeGroup = SubFeaturePrivilegeGroup;