"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureTableCell = void 0;
require("./feature_table_cell.scss");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FeatureTableCell = ({
  feature,
  className
}) => {
  let tooltipElement = null;
  if (feature.getPrivilegesTooltip()) {
    const tooltipContent = /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, feature.getPrivilegesTooltip()));
    tooltipElement = /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      iconProps: {
        className: 'eui-alignTop'
      },
      type: 'iInCircle',
      color: 'subdued',
      content: tooltipContent
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: className,
    direction: "column",
    gutterSize: "none",
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": `featureTableCell`,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "featurePrivilegeName",
    grow: false
  }, feature.name), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, tooltipElement))), feature.description && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    "data-test-subj": "featurePrivilegeDescriptionText",
    "aria-describedby": `${feature.name} description text`
  }, feature.description)));
};
exports.FeatureTableCell = FeatureTableCell;