"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteRoleButton = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DeleteRoleButton extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      showModal: false
    });
    (0, _defineProperty2.default)(this, "maybeShowModal", () => {
      if (!this.state.showModal) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.deleteRoleButton.deleteRoleTitle",
          defaultMessage: "Delete Role"
        }),
        onCancel: this.closeModal,
        onConfirm: this.onConfirmDelete,
        cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.deleteRoleButton.cancelButtonLabel",
          defaultMessage: "No, don't delete"
        }),
        confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.deleteRoleButton.confirmButtonLabel",
          defaultMessage: "Yes, delete role"
        }),
        buttonColor: 'danger'
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.deleteRoleButton.deletingRoleConfirmationText",
        defaultMessage: "Are you sure you want to delete this role?"
      })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.deleteRoleButton.deletingRoleWarningText",
        defaultMessage: "This action cannot be undone!"
      })));
    });
    (0, _defineProperty2.default)(this, "closeModal", () => {
      this.setState({
        showModal: false
      });
    });
    (0, _defineProperty2.default)(this, "showModal", () => {
      this.setState({
        showModal: true
      });
    });
    (0, _defineProperty2.default)(this, "onConfirmDelete", () => {
      this.closeModal();
      this.props.onDelete();
    });
  }
  render() {
    if (!this.props.canDelete) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: 'danger',
      onClick: this.showModal
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.deleteRoleButton.deleteRoleButtonLabel",
      defaultMessage: "Delete role"
    })), this.maybeShowModal());
  }
}
exports.DeleteRoleButton = DeleteRoleButton;