"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEditRoleMappingHref = exports.getCloneRoleMappingHref = exports.EDIT_ROLE_MAPPING_PATH = exports.CLONE_ROLE_MAPPING_PATH = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EDIT_ROLE_MAPPING_PATH = `/edit`;
exports.EDIT_ROLE_MAPPING_PATH = EDIT_ROLE_MAPPING_PATH;
const getEditRoleMappingHref = roleMappingName => `${EDIT_ROLE_MAPPING_PATH}/${encodeURIComponent(roleMappingName)}`;
exports.getEditRoleMappingHref = getEditRoleMappingHref;
const CLONE_ROLE_MAPPING_PATH = `/clone`;
exports.CLONE_ROLE_MAPPING_PATH = CLONE_ROLE_MAPPING_PATH;
const getCloneRoleMappingHref = roleMappingName => `${CLONE_ROLE_MAPPING_PATH}/${encodeURIComponent(roleMappingName)}`;
exports.getCloneRoleMappingHref = getCloneRoleMappingHref;