"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _register_user_context = require("./register_user_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The signature of the authentication type used by the user and the timestamp
 * indicating when the signature was calculated.
 */

class AnalyticsService {
  constructor() {
    (0, _defineProperty2.default)(this, "securityLicense", void 0);
    (0, _defineProperty2.default)(this, "securityFeaturesSubscription", void 0);
  }
  setup({
    analytics,
    authc,
    cloudId,
    http,
    securityLicense
  }) {
    this.securityLicense = securityLicense;
    if (http.anonymousPaths.isAnonymous(window.location.pathname) === false) {
      (0, _register_user_context.registerUserContext)(analytics, authc, cloudId);
    }
  }
  start({
    http
  }) {
    // Wait for the license info before recording authentication type. License
    // change events are throttled with 5s interval.
    this.securityFeaturesSubscription = this.securityLicense.features$.pipe((0, _rxjs.filter)(({
      allowLogin
    }) => allowLogin), (0, _operators.throttleTime)(5000), (0, _rxjs.switchMap)(async () => {
      try {
        await AnalyticsService.recordAuthTypeAnalytics(http);
      } catch {
        // do nothing
      }
    })).subscribe();
  }
  stop() {
    if (this.securityFeaturesSubscription) {
      this.securityFeaturesSubscription.unsubscribe();
      this.securityFeaturesSubscription = undefined;
    }
  }
  static async recordAuthTypeAnalytics(http) {
    localStorage.setItem(AnalyticsService.AuthTypeInfoStorageKey, JSON.stringify(await http.post('/internal/security/analytics/_record_auth_type', {
      body: localStorage.getItem(AnalyticsService.AuthTypeInfoStorageKey)
    })));
  }
}
exports.AnalyticsService = AnalyticsService;
(0, _defineProperty2.default)(AnalyticsService, "AuthTypeInfoStorageKey", 'kibana.security.userAuthType');