"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchProfilerUIPlugin = void 0;
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _common = require("../common");
var _locator = require("./locator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const checkLicenseStatus = license => {
  const {
    state,
    message
  } = license.check(_common.PLUGIN.id, _common.PLUGIN.minimumLicenseType);
  return state === 'valid' ? {
    valid: true
  } : {
    valid: false,
    message
  };
};
class SearchProfilerUIPlugin {
  setup({
    http,
    getStartServices
  }, {
    devTools,
    home,
    licensing,
    share
  }) {
    home.featureCatalogue.register({
      id: _common.PLUGIN.id,
      title: _i18n.i18n.translate('xpack.searchProfiler.registryProviderTitle', {
        defaultMessage: 'Search Profiler'
      }),
      description: _i18n.i18n.translate('xpack.searchProfiler.registryProviderDescription', {
        defaultMessage: 'Quickly check the performance of any Elasticsearch query.'
      }),
      icon: 'searchProfilerApp',
      path: '/app/dev_tools#/searchprofiler',
      showOnHomePage: false,
      category: 'admin'
    });
    const devTool = devTools.register({
      id: 'searchprofiler',
      title: _i18n.i18n.translate('xpack.searchProfiler.pageDisplayName', {
        defaultMessage: 'Search Profiler'
      }),
      order: 5,
      enableRouting: false,
      mount: async params => {
        const [coreStart] = await getStartServices();
        const {
          notifications,
          i18n: i18nDep
        } = coreStart;
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        const license = await (0, _rxjs.firstValueFrom)(licensing.license$);
        const initialLicenseStatus = checkLicenseStatus(license);
        return renderApp({
          http,
          initialLicenseStatus,
          el: params.element,
          I18nContext: i18nDep.Context,
          notifications: notifications.toasts,
          theme$: params.theme$,
          location: params.location
        });
      }
    });
    licensing.license$.subscribe(license => {
      if (!checkLicenseStatus(license).valid && !devTool.isDisabled()) {
        devTool.disable();
      } else if (devTool.isDisabled()) {
        devTool.enable();
      }
    });
    share.url.locators.create(new _locator.SearchProfilerLocatorDefinition());
  }
  start() {}
  stop() {}
}
exports.SearchProfilerUIPlugin = SearchProfilerUIPlugin;