"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TriggerMethod = exports.SyncStatus = exports.SyncJobType = exports.FilteringValidationState = exports.FilteringRuleRuleValues = exports.FieldType = exports.FeatureName = exports.DisplayType = exports.ConnectorStatus = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
let DisplayType;
exports.DisplayType = DisplayType;
(function (DisplayType) {
  DisplayType["TEXTBOX"] = "textbox";
  DisplayType["TEXTAREA"] = "textarea";
  DisplayType["NUMERIC"] = "numeric";
  DisplayType["TOGGLE"] = "toggle";
  DisplayType["DROPDOWN"] = "dropdown";
})(DisplayType || (exports.DisplayType = DisplayType = {}));
let FieldType;
exports.FieldType = FieldType;
(function (FieldType) {
  FieldType["STRING"] = "str";
  FieldType["INTEGER"] = "int";
  FieldType["LIST"] = "list";
  FieldType["BOOLEAN"] = "bool";
})(FieldType || (exports.FieldType = FieldType = {}));
let ConnectorStatus;
exports.ConnectorStatus = ConnectorStatus;
(function (ConnectorStatus) {
  ConnectorStatus["CREATED"] = "created";
  ConnectorStatus["NEEDS_CONFIGURATION"] = "needs_configuration";
  ConnectorStatus["CONFIGURED"] = "configured";
  ConnectorStatus["CONNECTED"] = "connected";
  ConnectorStatus["ERROR"] = "error";
})(ConnectorStatus || (exports.ConnectorStatus = ConnectorStatus = {}));
let SyncStatus;
exports.SyncStatus = SyncStatus;
(function (SyncStatus) {
  SyncStatus["CANCELING"] = "canceling";
  SyncStatus["CANCELED"] = "canceled";
  SyncStatus["COMPLETED"] = "completed";
  SyncStatus["ERROR"] = "error";
  SyncStatus["IN_PROGRESS"] = "in_progress";
  SyncStatus["PENDING"] = "pending";
  SyncStatus["SUSPENDED"] = "suspended";
})(SyncStatus || (exports.SyncStatus = SyncStatus = {}));
const FilteringRuleRuleValues = ['contains', 'ends_with', 'equals', '>', '<', 'regex', 'starts_with'];
exports.FilteringRuleRuleValues = FilteringRuleRuleValues;
let FilteringValidationState;
exports.FilteringValidationState = FilteringValidationState;
(function (FilteringValidationState) {
  FilteringValidationState["EDITED"] = "edited";
  FilteringValidationState["INVALID"] = "invalid";
  FilteringValidationState["VALID"] = "valid";
})(FilteringValidationState || (exports.FilteringValidationState = FilteringValidationState = {}));
let TriggerMethod;
exports.TriggerMethod = TriggerMethod;
(function (TriggerMethod) {
  TriggerMethod["ON_DEMAND"] = "on_demand";
  TriggerMethod["SCHEDULED"] = "scheduled";
})(TriggerMethod || (exports.TriggerMethod = TriggerMethod = {}));
let SyncJobType;
exports.SyncJobType = SyncJobType;
(function (SyncJobType) {
  SyncJobType["FULL"] = "full";
  SyncJobType["INCREMENTAL"] = "incremental";
  SyncJobType["ACCESS_CONTROL"] = "access_control";
})(SyncJobType || (exports.SyncJobType = SyncJobType = {}));
let FeatureName;
exports.FeatureName = FeatureName;
(function (FeatureName) {
  FeatureName["FILTERING_ADVANCED_CONFIG"] = "filtering_advanced_config";
  FeatureName["FILTERING_RULES"] = "filtering_rules";
  FeatureName["DOCUMENT_LEVEL_SECURITY"] = "document_level_security";
  FeatureName["INCREMENTAL_SYNC"] = "incremental_sync";
  FeatureName["SYNC_RULES"] = "sync_rules";
})(FeatureName || (exports.FeatureName = FeatureName = {}));