"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createConnector = void 0;
var _ = require("..");
var _create_connector_document = require("./create_connector_document");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createConnector = async (client, input) => {
  const document = (0, _create_connector_document.createConnectorDocument)({
    ...input,
    serviceType: input.serviceType || null
  });
  const result = await client.index({
    document,
    index: _.CURRENT_CONNECTORS_INDEX,
    refresh: input.instant_response ? false : 'wait_for'
  });
  return {
    ...document,
    id: result._id
  };
};
exports.createConnector = createConnector;