"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSearchSavedObject = exports.getSavedSearch = exports.getNewSavedSearch = exports.convertToSavedSearch = void 0;
var _common = require("@kbn/data-plugin/common");
var _i18n = require("@kbn/i18n");
var _ = require("..");
var _saved_searches_utils = require("./saved_searches_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// these won't exist in on server

const getSavedSearchUrlConflictMessage = async json => _i18n.i18n.translate('savedSearch.legacyURLConflict.errorMessage', {
  defaultMessage: `This search has the same URL as a legacy alias. Disable the alias to resolve this error : {json}`,
  values: {
    json
  }
});
const getSearchSavedObject = async (savedSearchId, {
  spaces,
  getSavedSrch
}) => {
  const so = await getSavedSrch(savedSearchId);

  // @ts-expect-error
  if (so.error) {
    throw new Error(`Could not locate that search (id: ${savedSearchId})`);
  }
  if (so.meta.outcome === 'conflict') {
    var _await$spaces$getActi;
    throw new Error(await getSavedSearchUrlConflictMessage(JSON.stringify({
      targetType: _.SavedSearchType,
      sourceId: savedSearchId,
      // front end only
      targetSpace: (_await$spaces$getActi = await (spaces === null || spaces === void 0 ? void 0 : spaces.getActiveSpace())) === null || _await$spaces$getActi === void 0 ? void 0 : _await$spaces$getActi.id
    })));
  }
  return so;
};
exports.getSearchSavedObject = getSearchSavedObject;
const convertToSavedSearch = async ({
  savedSearchId,
  attributes,
  references,
  sharingSavedObjectProps
}, {
  searchSourceCreate,
  savedObjectsTagging
}) => {
  var _attributes$kibanaSav, _attributes$kibanaSav2;
  const parsedSearchSourceJSON = (0, _common.parseSearchSourceJSON)((_attributes$kibanaSav = (_attributes$kibanaSav2 = attributes.kibanaSavedObjectMeta) === null || _attributes$kibanaSav2 === void 0 ? void 0 : _attributes$kibanaSav2.searchSourceJSON) !== null && _attributes$kibanaSav !== void 0 ? _attributes$kibanaSav : '{}');
  const searchSourceValues = (0, _common.injectReferences)(parsedSearchSourceJSON, references);

  // front end only
  const tags = savedObjectsTagging ? savedObjectsTagging.ui.getTagIdsFromReferences(references) : undefined;
  const returnVal = (0, _saved_searches_utils.fromSavedSearchAttributes)(savedSearchId, attributes, tags, references, await searchSourceCreate(searchSourceValues), sharingSavedObjectProps);
  return returnVal;
};
exports.convertToSavedSearch = convertToSavedSearch;
const getSavedSearch = async (savedSearchId, deps) => {
  const so = await getSearchSavedObject(savedSearchId, deps);
  const savedSearch = await convertToSavedSearch({
    savedSearchId,
    attributes: so.item.attributes,
    references: so.item.references,
    sharingSavedObjectProps: so.meta
  }, deps);
  return savedSearch;
};

/**
 * Returns a new saved search
 * Used when e.g. Discover is opened without a saved search id
 * @param search
 */
exports.getSavedSearch = getSavedSearch;
const getNewSavedSearch = ({
  searchSource
}) => ({
  searchSource: searchSource.createEmpty()
});
exports.getNewSavedSearch = getNewSavedSearch;