"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEditAction = void 0;
var _i18n = require("@kbn/i18n");
var _edition_modal = require("../../components/edition_modal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEditAction = ({
  notifications,
  theme,
  overlays,
  tagClient,
  fetchTags
}) => {
  const editModalOpener = (0, _edition_modal.getEditModalOpener)({
    overlays,
    theme,
    tagClient,
    notifications
  });
  return {
    id: 'edit',
    name: ({
      name
    }) => _i18n.i18n.translate('xpack.savedObjectsTagging.management.table.actions.edit.title', {
      defaultMessage: 'Edit {name} tag',
      values: {
        name
      }
    }),
    isPrimary: true,
    description: _i18n.i18n.translate('xpack.savedObjectsTagging.management.table.actions.edit.description', {
      defaultMessage: 'Edit this tag'
    }),
    type: 'icon',
    icon: 'pencil',
    onClick: tag => {
      editModalOpener({
        tagId: tag.id,
        onUpdate: updatedTag => {
          fetchTags();
          notifications.toasts.addSuccess({
            title: _i18n.i18n.translate('xpack.savedObjectsTagging.notifications.editTagSuccessTitle', {
              defaultMessage: 'Saved changes to "{name}" tag',
              values: {
                name: updatedTag.name
              }
            })
          });
        }
      });
    },
    'data-test-subj': 'tagsTableAction-edit'
  };
};
exports.getEditAction = getEditAction;