"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serializeSavedObject = serializeSavedObject;
var _lodash = require("lodash");
var _public = require("@kbn/data-plugin/public");
var _field_mapping = require("./field_mapping");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function serializeSavedObject(savedObject, config) {
  var _config$mapping;
  // mapping definition for the fields that this object will expose
  const mapping = (0, _field_mapping.expandShorthand)((_config$mapping = config.mapping) !== null && _config$mapping !== void 0 ? _config$mapping : {});
  const attributes = {};
  const references = [];
  (0, _lodash.forOwn)(mapping, (fieldMapping, fieldName) => {
    if (typeof fieldName !== 'string') {
      return;
    }
    // @ts-ignore
    const savedObjectFieldVal = savedObject[fieldName];
    if (savedObjectFieldVal != null) {
      attributes[fieldName] = fieldMapping._serialize ? fieldMapping._serialize(savedObjectFieldVal) : savedObjectFieldVal;
    }
  });
  if (savedObject.searchSource) {
    const {
      searchSourceJSON,
      references: searchSourceReferences
    } = savedObject.searchSource.serialize();
    attributes.kibanaSavedObjectMeta = {
      searchSourceJSON
    };
    references.push(...searchSourceReferences);
  }
  if (savedObject.searchSourceFields) {
    const [searchSourceFields, searchSourceReferences] = (0, _public.extractSearchSourceReferences)(savedObject.searchSourceFields);
    const searchSourceJSON = JSON.stringify(searchSourceFields);
    attributes.kibanaSavedObjectMeta = {
      searchSourceJSON
    };
    references.push(...searchSourceReferences);
  }
  if (savedObject.unresolvedIndexPatternReference) {
    references.push(savedObject.unresolvedIndexPatternReference);
  }
  return {
    attributes,
    references
  };
}