"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toSavedObjectWithMeta = toSavedObjectWithMeta;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function toSavedObjectWithMeta(so) {
  return {
    id: so.id,
    type: so.type,
    namespaces: so.namespaces,
    references: so.references,
    updated_at: so.updated_at,
    attributes: so.attributes,
    created_at: so.created_at,
    error: so.error,
    meta: {}
  };
}