"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsManagementColumnService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _columns = require("./columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class SavedObjectsManagementColumnService {
  constructor() {
    (0, _defineProperty2.default)(this, "columns", new Map());
  }
  setup() {
    return {
      register: column => {
        if (this.columns.has(column.id)) {
          throw new Error(`Saved Objects Management Column with id '${column.id}' already exists`);
        }
        this.columns.set(column.id, column);
      }
    };
  }
  start(spacesApi) {
    if (spacesApi && !spacesApi.hasOnlyDefaultSpace) {
      registerSpacesApiColumns(this, spacesApi);
    }
    return {
      getAll: () => [...this.columns.values()]
    };
  }
}
exports.SavedObjectsManagementColumnService = SavedObjectsManagementColumnService;
function registerSpacesApiColumns(service, spacesApi) {
  service.setup().register(new _columns.ShareToSpaceSavedObjectsManagementColumn(spacesApi.ui));
}