"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectEdition = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _public = require("@kbn/kibana-react-plugin/public");
var _components = require("./components");
var _lib = require("../../lib");
require("./saved_object_view.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const unableFindSavedObjectNotificationMessage = _i18n.i18n.translate('savedObjectsManagement.objectView.unableFindSavedObjectNotificationMessage', {
  defaultMessage: 'Unable to find saved object'
});
class SavedObjectEdition extends _react.Component {
  constructor(props) {
    super(props);
    const {
      savedObjectType: type
    } = props;
    this.state = {
      object: undefined,
      type
    };
  }
  componentDidMount() {
    const {
      http,
      id,
      notifications
    } = this.props;
    const {
      type
    } = this.state;
    (0, _lib.bulkGetObjects)(http, [{
      type,
      id
    }]).then(([object]) => {
      if (object.error) {
        const {
          message
        } = object.error;
        notifications.toasts.addDanger({
          title: unableFindSavedObjectNotificationMessage,
          text: message
        });
      } else {
        this.setState({
          object
        });
      }
    }).catch(err => {
      var _err$message;
      notifications.toasts.addDanger({
        title: unableFindSavedObjectNotificationMessage,
        text: (_err$message = err.message) !== null && _err$message !== void 0 ? _err$message : 'Unknown error'
      });
    });
  }
  canViewInApp(capabilities, obj) {
    var _obj$meta$inAppUrl, _obj$meta$inAppUrl2;
    return obj && obj.meta.inAppUrl ? (0, _lodash.get)(capabilities, obj === null || obj === void 0 ? void 0 : (_obj$meta$inAppUrl = obj.meta.inAppUrl) === null || _obj$meta$inAppUrl === void 0 ? void 0 : _obj$meta$inAppUrl.uiCapabilitiesPath, false) && Boolean(obj === null || obj === void 0 ? void 0 : (_obj$meta$inAppUrl2 = obj.meta.inAppUrl) === null || _obj$meta$inAppUrl2 === void 0 ? void 0 : _obj$meta$inAppUrl2.path) : false;
  }
  render() {
    var _object$meta$inAppUrl;
    const {
      capabilities,
      notFoundType,
      http,
      uiSettings,
      docLinks,
      settings,
      theme
    } = this.props;
    const {
      object
    } = this.state;
    const {
      delete: canDelete
    } = capabilities.savedObjectsManagement;
    const canView = this.canViewInApp(capabilities, object);
    return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        uiSettings,
        settings,
        theme
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      "data-test-subject": "savedObjectsEdit",
      className: "savedObjectsManagementObjectView"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_components.Header, {
      canDelete: canDelete && !(object !== null && object !== void 0 && object.meta.hiddenType),
      canViewInApp: canView,
      onDeleteClick: () => this.delete(),
      viewUrl: http.basePath.prepend((object === null || object === void 0 ? void 0 : (_object$meta$inAppUrl = object.meta.inAppUrl) === null || _object$meta$inAppUrl === void 0 ? void 0 : _object$meta$inAppUrl.path) || ''),
      title: object === null || object === void 0 ? void 0 : object.meta.title
    })), notFoundType && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_components.NotFoundErrors, {
      type: notFoundType,
      docLinks: docLinks
    })), object && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_components.Inspect, {
      object: object
    }))));
  }
  async delete() {
    var _object$meta, _object$meta3;
    const {
      http,
      id,
      overlays,
      notifications
    } = this.props;
    const {
      type,
      object
    } = this.state;
    const confirmed = await overlays.openConfirm(_i18n.i18n.translate('savedObjectsManagement.deleteConfirm.modalDescription', {
      defaultMessage: 'This action permanently removes the object from Kibana.'
    }), {
      confirmButtonText: _i18n.i18n.translate('savedObjectsManagement.deleteConfirm.modalDeleteButtonLabel', {
        defaultMessage: 'Delete'
      }),
      title: _i18n.i18n.translate('savedObjectsManagement.deleteConfirm.modalTitle', {
        defaultMessage: `Delete '{title}'?`,
        values: {
          title: (object === null || object === void 0 ? void 0 : (_object$meta = object.meta) === null || _object$meta === void 0 ? void 0 : _object$meta.title) || 'saved Kibana object'
        }
      }),
      buttonColor: 'danger'
    });
    if (!confirmed) {
      return;
    }
    const [{
      success,
      error
    }] = await (0, _lib.bulkDeleteObjects)(http, [{
      id,
      type
    }]);
    if (!success) {
      var _object$meta2;
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('savedObjectsManagement.objectView.unableDeleteSavedObjectNotificationMessage', {
          defaultMessage: `Failed to delete '{title}' {type} object`,
          values: {
            type,
            title: object === null || object === void 0 ? void 0 : (_object$meta2 = object.meta) === null || _object$meta2 === void 0 ? void 0 : _object$meta2.title
          }
        }),
        text: error === null || error === void 0 ? void 0 : error.message
      });
      return;
    }
    notifications.toasts.addSuccess(`Deleted '${object === null || object === void 0 ? void 0 : (_object$meta3 = object.meta) === null || _object$meta3 === void 0 ? void 0 : _object$meta3.title}' ${type} object`);
    this.redirectToListing();
  }
  redirectToListing() {
    this.props.history.push('/');
  }
}
exports.SavedObjectEdition = SavedObjectEdition;