"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuntimeFieldEditorFlyoutContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _runtime_field_editor = require("../runtime_field_editor/runtime_field_editor");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const geti18nTexts = field => {
  return {
    flyoutTitle: field ? _i18n.i18n.translate('xpack.runtimeFields.editor.flyoutEditFieldTitle', {
      defaultMessage: 'Edit {fieldName} field',
      values: {
        fieldName: field.name
      }
    }) : _i18n.i18n.translate('xpack.runtimeFields.editor.flyoutDefaultTitle', {
      defaultMessage: 'Create new field'
    }),
    closeButtonLabel: _i18n.i18n.translate('xpack.runtimeFields.editor.flyoutCloseButtonLabel', {
      defaultMessage: 'Close'
    }),
    saveButtonLabel: _i18n.i18n.translate('xpack.runtimeFields.editor.flyoutSaveButtonLabel', {
      defaultMessage: 'Save'
    }),
    formErrorsCalloutTitle: _i18n.i18n.translate('xpack.runtimeFields.editor.validationErrorTitle', {
      defaultMessage: 'Fix errors in form before continuing.'
    })
  };
};
const RuntimeFieldEditorFlyoutContent = ({
  onSave,
  onCancel,
  docLinks,
  defaultValue: field,
  ctx
}) => {
  const i18nTexts = geti18nTexts(field);
  const [formState, setFormState] = (0, _react.useState)({
    isSubmitted: false,
    isValid: field ? true : undefined,
    submit: field ? async () => ({
      isValid: true,
      data: field
    }) : async () => ({
      isValid: false,
      data: {}
    })
  });
  const {
    submit,
    isValid: isFormValid,
    isSubmitted
  } = formState;
  const onSaveField = (0, _react.useCallback)(async () => {
    const {
      isValid,
      data
    } = await submit();
    if (isValid) {
      onSave(data);
    }
  }, [submit, onSave]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    "data-test-subj": "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "runtimeFieldEditorEditTitle"
  }, i18nTexts.flyoutTitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_runtime_field_editor.RuntimeFieldEditor, {
    docLinks: docLinks,
    defaultValue: field,
    onChange: setFormState,
    ctx: ctx
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, isSubmitted && !isFormValid && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.formErrorsCalloutTitle,
    color: "danger",
    iconType: "cross",
    "data-test-subj": "formError"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    flush: "left",
    onClick: () => onCancel(),
    "data-test-subj": "closeFlyoutButton"
  }, i18nTexts.closeButtonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    onClick: () => onSaveField(),
    "data-test-subj": "saveFieldButton",
    disabled: isSubmitted && !isFormValid,
    fill: true
  }, i18nTexts.saveButtonLabel)))));
};
exports.RuntimeFieldEditorFlyoutContent = RuntimeFieldEditorFlyoutContent;