"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobTable = void 0;
var _reactRedux = require("react-redux");
var _selectors = require("../../../store/selectors");
var _actions = require("../../../store/actions");
var _job_table = require("./job_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapStateToProps = state => {
  return {
    jobs: (0, _selectors.getPageOfJobs)(state),
    pager: (0, _selectors.getPager)(state),
    filter: (0, _selectors.getFilter)(state),
    sortField: (0, _selectors.getSortField)(state),
    isSortAscending: (0, _selectors.isSortAscending)(state)
  };
};
const mapDispatchToProps = dispatch => {
  return {
    closeDetailPanel: () => {
      dispatch((0, _actions.closeDetailPanel)());
    },
    filterChanged: filter => {
      dispatch((0, _actions.filterChanged)({
        filter
      }));
    },
    pageChanged: pageNumber => {
      dispatch((0, _actions.pageChanged)({
        pageNumber
      }));
    },
    pageSizeChanged: pageSize => {
      dispatch((0, _actions.pageSizeChanged)({
        pageSize
      }));
    },
    sortChanged: (sortField, isSortAscending) => {
      dispatch((0, _actions.sortChanged)({
        sortField,
        isSortAscending
      }));
    },
    openDetailPanel: jobId => {
      dispatch((0, _actions.openDetailPanel)({
        jobId: jobId
      }));
    }
  };
};
const JobTable = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_job_table.JobTable);
exports.JobTable = JobTable;