"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepHistogram = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _documentation_links = require("../../../services/documentation_links");
var _components = require("../../components");
var _components2 = require("./components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StepHistogram extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "onSelectField", field => {
      const {
        fields: {
          histogram
        },
        onFieldsChange
      } = this.props;
      onFieldsChange({
        histogram: histogram.concat(field)
      });
    });
    (0, _defineProperty2.default)(this, "onRemoveField", field => {
      const {
        fields: {
          histogram
        },
        onFieldsChange
      } = this.props;
      onFieldsChange({
        histogram: histogram.filter(histogramField => histogramField !== field)
      });
    });
    (0, _defineProperty2.default)(this, "renderErrors", () => {
      const {
        areStepErrorsVisible,
        hasErrors
      } = this.props;
      if (!areStepErrorsVisible || !hasErrors) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_components2.StepError, null);
    });
  }
  render() {
    const {
      fields,
      histogramFields
    } = this.props;
    const {
      histogram
    } = fields;
    const columns = [{
      field: 'name',
      name: 'Field',
      sortable: true
    }];
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      "data-test-subj": "rollupJobCreateHistogramTitle"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepHistogramTitle",
      defaultMessage: "Histogram (optional)"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepHistogram.histogramDescription",
      defaultMessage: "Select the fields you want to bucket using numeric intervals."
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: "rollupJobWizardStepActions"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      flush: "right",
      href: _documentation_links.documentationLinks.apis.createRollupJobsRequest,
      target: "_blank",
      iconType: "help",
      "data-test-subj": "rollupJobCreateHistogramDocsButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepHistogram.readDocsButtonLabel",
      defaultMessage: "Histogram docs"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_components.FieldList, {
      columns: columns,
      fields: histogram,
      onRemoveField: this.onRemoveField,
      emptyMessage: /*#__PURE__*/_react.default.createElement("p", null, "No histogram fields added"),
      addButton: /*#__PURE__*/_react.default.createElement(_components2.FieldChooser, {
        buttonLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.rollupJobs.create.stepHistogram.fieldsChooserLabel",
          defaultMessage: "Add histogram fields"
        }),
        columns: columns,
        fields: histogramFields,
        selectedFields: histogram,
        onSelectField: this.onSelectField,
        dataTestSubj: "rollupJobHistogramFieldChooser"
      }),
      dataTestSubj: "rollupJobHistogramFieldList"
    }), this.renderInterval(), this.renderErrors());
  }
  renderInterval() {
    const {
      fields,
      onFieldsChange,
      areStepErrorsVisible,
      fieldErrors
    } = this.props;
    const {
      histogram,
      histogramInterval
    } = fields;
    const {
      histogramInterval: errorHistogramInterval
    } = fieldErrors;
    if (!histogram.length) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xl"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepHistogram.sectionHistogramIntervalTitle",
        defaultMessage: "Histogram interval"
      }))),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepHistogram.sectionHistogramIntervalDescription",
        defaultMessage: "This is the interval of histogram buckets to be generated when rolling up, e.g. 5 will create buckets that are five units wide (0-5, 5-10, etc). Note that only one interval can be specified in the histogram group, meaning that all fields being grouped via the histogram must share the same interval."
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepHistogram.fieldHistogramIntervalLabel",
        defaultMessage: "Interval"
      }),
      error: errorHistogramInterval,
      isInvalid: Boolean(areStepErrorsVisible && errorHistogramInterval),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: !histogramInterval && histogramInterval !== 0 ? '' : Number(histogramInterval),
      onChange: e => onFieldsChange({
        histogramInterval: e.target.value
      }),
      isInvalid: Boolean(areStepErrorsVisible && errorHistogramInterval),
      fullWidth: true,
      "data-test-subj": "rollupJobCreateHistogramInterval"
    }))));
  }
}
exports.StepHistogram = StepHistogram;
(0, _defineProperty2.default)(StepHistogram, "propTypes", {
  fields: _propTypes.default.object.isRequired,
  onFieldsChange: _propTypes.default.func.isRequired,
  fieldErrors: _propTypes.default.object.isRequired,
  hasErrors: _propTypes.default.bool.isRequired,
  areStepErrorsVisible: _propTypes.default.bool.isRequired,
  histogramFields: _propTypes.default.array.isRequired
});