"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decode = decode;
exports.decodeArray = decodeArray;
exports.encode = encode;
exports.encodeArray = encodeArray;
exports.encodeUnknown = encodeUnknown;
exports.safeDecode = safeDecode;
var _risonNode = _interopRequireDefault(require("rison-node"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// @ts-expect-error untyped module from npm
// eslint-disable-next-line @kbn/eslint/module_migration

function encodeUnknown(obj) {
  return _risonNode.default.encode(obj);
}

/**
 * rison-encode a javascript structure
 */
function encode(obj) {
  const rison = encodeUnknown(obj);
  if (rison === undefined) {
    throw new Error('unable to encode value into rison, expected a primitive value array or object');
  }
  return rison;
}

/**
 * parse a rison string into a javascript structure.
 */
function decode(rison) {
  return _risonNode.default.decode(rison);
}

/**
 * safely parse a rison string into a javascript structure, never throws
 */
function safeDecode(rison) {
  try {
    return decode(rison);
  } catch {
    return null;
  }
}

/**
 * rison-encode a javascript array without surrounding parens
 */
function encodeArray(array) {
  return _risonNode.default.encode_array(array);
}

/**
 * parse an a-rison string into a javascript structure.
 *
 * this simply adds array markup around the string before parsing.
 */
function decodeArray(rison) {
  return _risonNode.default.decode_array(rison);
}