"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorUnsavedWorkPanel = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  title: _i18n.i18n.translate('xpack.reporting.panelContent.unsavedStateErrorTitle', {
    defaultMessage: 'Unsaved work'
  })
};
const ErrorUnsavedWorkPanel = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: i18nTexts.title,
    iconType: "warning",
    color: "danger",
    "data-test-subj": "shareReportingUnsavedState"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.reporting.panelContent.unsavedStateErrorText",
    defaultMessage: "Save your work before copying this URL."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
};
exports.ErrorUnsavedWorkPanel = ErrorUnsavedWorkPanel;