"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reportingCsvShareProvider = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reportingExportTypesCsvCommon = require("@kbn/reporting-export-types-csv-common");
var _license_check = require("../lib/license_check");
var _reporting_panel_content_lazy = require("./reporting_panel_content_lazy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reportingCsvShareProvider = ({
  apiClient,
  toasts,
  uiSettings,
  application,
  license,
  usesUiCapabilities,
  theme
}) => {
  const getShareMenuItems = ({
    objectType,
    objectId,
    sharingData,
    onClose
  }) => {
    if ('search' !== objectType) {
      return [];
    }
    const getSearchSource = sharingData.getSearchSource;
    const jobParams = {
      title: sharingData.title,
      objectType,
      columns: sharingData.columns
    };
    const getJobParams = forShareUrl => {
      return {
        ...jobParams,
        searchSource: getSearchSource({
          addGlobalTimeFilter: true,
          absoluteTime: !forShareUrl
        })
      };
    };
    const shareActions = [];
    const licenseCheck = (0, _license_check.checkLicense)(license.check('reporting', 'basic'));
    const licenseToolTipContent = licenseCheck.message;
    const licenseHasCsvReporting = licenseCheck.showLinks;
    const licenseDisabled = !licenseCheck.enableLinks;

    // TODO: add abstractions in ExportTypeRegistry to use here?
    let capabilityHasCsvReporting = false;
    if (usesUiCapabilities) {
      var _application$capabili;
      capabilityHasCsvReporting = ((_application$capabili = application.capabilities.discover) === null || _application$capabili === void 0 ? void 0 : _application$capabili.generateCsv) === true;
    } else {
      capabilityHasCsvReporting = true; // deprecated
    }

    if (licenseHasCsvReporting && capabilityHasCsvReporting) {
      const panelTitle = _i18n.i18n.translate('xpack.reporting.shareContextMenu.csvReportsButtonLabel', {
        defaultMessage: 'CSV Reports'
      });
      shareActions.push({
        shareMenuItem: {
          name: panelTitle,
          icon: 'document',
          toolTipContent: licenseToolTipContent,
          disabled: licenseDisabled,
          ['data-test-subj']: 'CSVReports',
          sortOrder: 1
        },
        panel: {
          id: 'csvReportingPanel',
          title: panelTitle,
          content: /*#__PURE__*/_react.default.createElement(_reporting_panel_content_lazy.ReportingPanelContent, {
            requiresSavedState: false,
            apiClient: apiClient,
            toasts: toasts,
            uiSettings: uiSettings,
            reportType: _reportingExportTypesCsvCommon.CSV_JOB_TYPE,
            layoutId: undefined,
            objectId: objectId,
            getJobParams: getJobParams,
            onClose: onClose,
            theme: theme
          })
        }
      });
    }
    return shareActions;
  };
  return {
    id: 'csvReports',
    getShareMenuItems
  };
};
exports.reportingCsvShareProvider = reportingCsvShareProvider;