"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectInConsoleButton = void 0;
var _lzString = require("lz-string");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _reportingExportTypesCsvCommon = require("@kbn/reporting-export-types-csv-common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InspectInConsoleButtonUi = props => {
  const {
    csvConfig,
    job,
    searchSourceStart,
    locators
  } = props;
  const {
    title: jobTitle
  } = job;
  const serializedSearchSource = job.payload.searchSource;
  const handleDevToolsLinkClick = (0, _react.useCallback)(async () => {
    const searchSource = await searchSourceStart.create(serializedSearchSource);
    const index = searchSource.getField('index');
    if (!index) {
      throw new Error(`The search must have a reference to an index pattern!`);
    }
    const indexPatternTitle = index.getIndexPattern();
    const examplePitId = _i18n.i18n.translate('xpack.reporting.reportInfoFlyout.devToolsContent.examplePitId', {
      defaultMessage: `[ID returned from first request]`,
      description: `This gets used in place of an ID string that is sent in a request body.`
    });
    const queryInfo = (0, _reportingExportTypesCsvCommon.getQueryFromCsvJob)(searchSource, csvConfig, examplePitId);
    const queryUri = (0, _lzString.compressToEncodedURIComponent)(getTextForConsole(jobTitle, indexPatternTitle, queryInfo, csvConfig));
    const consoleLocator = locators.get('CONSOLE_APP_LOCATOR');
    consoleLocator === null || consoleLocator === void 0 ? void 0 : consoleLocator.navigate({
      loadFrom: `data:text/plain,${queryUri}`
    });
  }, [searchSourceStart, serializedSearchSource, jobTitle, csvConfig, locators]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "reportInfoFlyoutOpenInConsoleButton",
    key: "download",
    icon: "wrench",
    onClick: handleDevToolsLinkClick
  }, _i18n.i18n.translate('xpack.reporting.reportInfoFlyout.openInConsole', {
    defaultMessage: 'Inspect query in Console',
    description: 'An option in a menu of actions.'
  }));
};
const InspectInConsoleButton = props => {
  const {
    config,
    job
  } = props;
  const {
    services
  } = (0, _public.useKibana)();
  const {
    application,
    data,
    share
  } = services;
  const {
    capabilities
  } = application;
  const {
    locators
  } = share.url;

  // To show the Console button,
  // check if job object type is search,
  // and if both the Dev Tools UI and the Console UI are enabled.
  const canShowDevTools = job.objectType === 'search' && capabilities.dev_tools.show;
  if (!canShowDevTools) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(InspectInConsoleButtonUi, {
    searchSourceStart: data.search.searchSource,
    locators: locators,
    job: job,
    csvConfig: config.csv
  });
};
exports.InspectInConsoleButton = InspectInConsoleButton;
const getTextForConsole = (jobTitle, indexPattern, queryInfo, csvConfig) => {
  const {
    requestBody
  } = queryInfo;
  const queryAsString = JSON.stringify(requestBody, null, '  ');
  const pitRequest = `POST /${indexPattern}/_pit?keep_alive=${csvConfig.scroll.duration}` + `&ignore_unavailable=true`;
  const queryRequest = `POST /_search`;
  const closePitRequest = `DELETE /_pit\n${JSON.stringify({
    id: `[ID returned from latest request]`
  })}`;
  const introText = _i18n.i18n.translate(
  // intro to the content
  'xpack.reporting.reportInfoFlyout.devToolsContent.introText', {
    description: `Script used in the Console app`,
    defaultMessage: `
# Report title: {jobTitle}
# These are the queries used when exporting data for
# the CSV report.
#
# For reference about the Elasticsearch Point-In-Time
# API, see
# https://www.elastic.co/guide/en/elasticsearch/reference/current/point-in-time-api.html

# The first query opens a Point-In-Time (PIT) context
# and receive back the ID reference. The "keep_alive"
# value is taken from the
# "xpack.reporting.csv.scroll.duration" setting.
#
# The response will include an "id" value, which is
# needed for the second query.
{pitRequest}`,
    values: {
      jobTitle,
      pitRequest
    }
  });
  const queryText = _i18n.i18n.translate(
  // query with the request path and body
  'xpack.reporting.reportInfoFlyout.devToolsContent.queryText', {
    description: `Script used in the Console app`,
    defaultMessage: `
# The second query executes a search using the PIT ID.
# The "keep_alive" and "size" values come from the
# "xpack.reporting.csv.scroll.duration" and
# "xpack.reporting.csv.scroll.size" settings in
# kibana.yml.
#
# The reponse will include new a PIT ID, which might
# not be the same as the ID returned from the first
# query.
{queryRequest}
{queryAsString}`,
    values: {
      queryRequest,
      queryAsString
    }
  });
  const pagingText = _i18n.i18n.translate(
  // info about querying further pages, and link to documentation
  'xpack.reporting.reportInfoFlyout.devToolsContent.pagingText', {
    description: `Script used in the Console app`,
    defaultMessage: `# The first request retrieves the first page of search
# results. If you want to retrieve more hits, use PIT
# with search_after. Always use the PIT ID from the
# latest search response. See
# https://www.elastic.co/guide/en/elasticsearch/reference/current/paginate-search-results.html`
  });
  const closingText = _i18n.i18n.translate(
  // reminder to close the point-in-time context
  'xpack.reporting.reportInfoFlyout.devToolsContent.closingText', {
    description: `Script used in the Console app`,
    defaultMessage: `
# Finally, release the resources held in Elasticsearch
# memory by clearing the PIT.
{closePitRequest}
  `,
    values: {
      closePitRequest
    }
  });
  return (introText + queryText + pagingText + closingText).trim();
};