"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterEdit = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _shared_imports = require("../../../shared_imports");
var _services = require("../../services");
var _breadcrumb = require("../../services/breadcrumb");
var _components = require("../components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RemoteClusterEdit extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "save", clusterConfig => {
      this.props.editCluster(clusterConfig);
    });
    (0, _defineProperty2.default)(this, "cancel", () => {
      const {
        openDetailPanel
      } = this.props;
      const {
        clusterName
      } = this.state;
      const {
        history,
        route: {
          location: {
            search
          }
        }
      } = (0, _services.getRouter)();
      const {
        redirect: redirectUrl
      } = (0, _shared_imports.extractQueryParams)(search);
      if (redirectUrl) {
        const decodedRedirect = decodeURIComponent(redirectUrl);
        (0, _services.redirect)(decodedRedirect);
      } else {
        history.push('/list');
        openDetailPanel(clusterName);
      }
    });
    const {
      match: {
        params: {
          name
        }
      }
    } = props;
    (0, _breadcrumb.setBreadcrumbs)('edit', `?cluster=${name}`);
    this.state = {
      clusterName: name
    };
  }
  componentDidMount() {
    const {
      startEditingCluster
    } = this.props;
    const {
      clusterName
    } = this.state;
    startEditingCluster(clusterName);
  }
  componentWillUnmount() {
    // Clean up after ourselves.
    this.props.clearEditClusterErrors();
    this.props.stopEditingCluster();
  }
  render() {
    const {
      clusterName
    } = this.state;
    const {
      isLoading,
      cluster,
      isEditingCluster,
      getEditClusterError
    } = this.props;
    if (isLoading) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.edit.loadingLabel",
        defaultMessage: "Loading remote cluster\u2026"
      }));
    }
    if (!cluster) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
        iconType: "warning",
        color: "danger",
        title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.remoteClusters.edit.loadingErrorTitle",
          defaultMessage: "Error loading remote cluster"
        })),
        body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.remoteClusters.edit.loadingErrorMessage",
          defaultMessage: "The remote cluster '{name}' does not exist.",
          values: {
            name: clusterName
          }
        })),
        actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(this.props.history, '/list'), {
          color: "danger",
          iconType: "arrowLeft",
          flush: "left"
        }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.remoteClusters.edit.viewRemoteClustersButtonLabel",
          defaultMessage: "View remote clusters"
        }))
      });
    }
    const {
      isConfiguredByNode,
      hasDeprecatedProxySetting
    } = cluster;
    if (isConfiguredByNode) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
        iconType: "iInCircle",
        title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.remoteClusters.edit.configuredByNodeWarningTitle",
          defaultMessage: "Defined in configuration"
        })),
        body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.remoteClusters.configuredByNodeWarningBody",
          defaultMessage: "You can't edit or delete this remote cluster because it's defined in a node's elasticsearch.yml configuration file."
        })),
        actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          color: "primary",
          iconType: "arrowLeft",
          flush: "left",
          onClick: this.cancel
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.remoteClusters.edit.backToRemoteClustersButtonLabel",
          defaultMessage: "Back to remote clusters"
        }))
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
      restrictWidth: true,
      "data-test-subj": "remote-clusters-edit"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      paddingSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_components.RemoteClusterPageTitle, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.editTitle",
        defaultMessage: "Edit remote cluster"
      })
    }), hasDeprecatedProxySetting ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.edit.deprecatedSettingsTitle",
        defaultMessage: "Proceed with caution"
      }),
      color: "warning",
      iconType: "help"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.edit.deprecatedSettingsMessage",
      defaultMessage: "This remote cluster has deprecated settings that we tried to resolve. Verify all changes before saving."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, /*#__PURE__*/_react.default.createElement(_components.RemoteClusterForm, {
      cluster: cluster,
      isSaving: isEditingCluster,
      saveError: getEditClusterError,
      save: this.save,
      cancel: this.cancel
    })));
  }
}
exports.RemoteClusterEdit = RemoteClusterEdit;
(0, _defineProperty2.default)(RemoteClusterEdit, "propTypes", {
  isLoading: _propTypes.default.bool,
  cluster: _propTypes.default.object,
  startEditingCluster: _propTypes.default.func,
  stopEditingCluster: _propTypes.default.func,
  editCluster: _propTypes.default.func,
  isEditingCluster: _propTypes.default.bool,
  getEditClusterError: _propTypes.default.object,
  clearEditClusterErrors: _propTypes.default.func,
  openDetailPanel: _propTypes.default.func
});