"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmTrustSetupModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmTrustSetupModal = ({
  closeModal,
  onSubmit
}) => {
  const [hasSetupTrust, setHasSetupTrust] = (0, _react.useState)(false);
  const modalFormId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'modalForm'
  });
  const checkBoxId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'checkBoxId'
  });
  const onFormSubmit = e => {
    e.preventDefault();
    closeModal();
    onSubmit();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.clusterWizard.trustStep.modal.title",
    defaultMessage: "Confirm your configuration"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.clusterWizard.trustStep.body",
    defaultMessage: "Have you set up trust to connect to your remote cluster?"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    id: modalFormId,
    component: "form",
    onSubmit: onFormSubmit
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: checkBoxId,
    label: _i18n.i18n.translate('xpack.remoteClusters.clusterWizard.trustStep.modal.checkbox', {
      defaultMessage: 'Yes, I have setup trust'
    }),
    labelProps: {
      'data-test-subj': 'remoteClusterTrustCheckboxLabel'
    },
    checked: hasSetupTrust,
    onChange: () => setHasSetupTrust(!hasSetupTrust),
    "data-test-subj": "remoteClusterTrustCheckbox"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.clusterWizard.trustStep.modal.cancelButton",
    defaultMessage: "No, go back"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    type: "submit",
    form: modalFormId,
    disabled: !hasSetupTrust,
    "data-test-subj": "remoteClusterTrustSubmitButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.clusterWizard.trustStep.modal.createCluster",
    defaultMessage: "Add remote cluster"
  }))));
};
exports.ConfirmTrustSetupModal = ConfirmTrustSetupModal;