"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableFunctionsGrid = EmbeddableFunctionsGrid;
var _profilingUtils = require("@kbn/profiling-utils");
var _react = _interopRequireWildcard(require("react"));
var _topn_functions = require("../../components/topn_functions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EmbeddableFunctionsGrid({
  data,
  totalSeconds
}) {
  const [sortField, setSortField] = (0, _react.useState)(_profilingUtils.TopNFunctionSortField.Rank);
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  return /*#__PURE__*/_react.default.createElement(_topn_functions.TopNFunctionsGrid, {
    topNFunctions: data,
    totalSeconds: totalSeconds,
    isDifferentialView: false,
    pageIndex: pageIndex,
    onChangePage: setPageIndex,
    sortField: sortField,
    sortDirection: sortDirection,
    onChangeSort: sorting => {
      setSortField(sorting.id);
      setSortDirection(sorting.direction);
    },
    isEmbedded: true
  });
}