"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createReduxTools = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _uuid = require("uuid");
var _react = require("react");
var _reactRedux = require("react-redux");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createReduxTools = ({
  reducers,
  additionalMiddleware,
  initialState
}) => {
  const id = (0, _uuid.v4)();

  /**
   * Create slice out of reducers and embeddable initial state.
   */
  const slice = (0, _toolkit.createSlice)({
    initialState,
    name: id,
    reducers
  });
  const store = (0, _toolkit.configureStore)({
    reducer: slice.reducer,
    middleware: getDefaultMiddleware => getDefaultMiddleware().concat(...(additionalMiddleware !== null && additionalMiddleware !== void 0 ? additionalMiddleware : []))
  });

  /**
   * Create an object of setter functions by looping through the reducers, and creating a method that dispatches the related
   * action to the appropriate store.
   */
  const dispatch = Object.keys(reducers).reduce((acc, key) => {
    const sliceAction = slice.actions[key];
    acc[key] = payload => store.dispatch(sliceAction(payload));
    return acc;
  }, {});

  /**
   * Create a selector which can be used by react components to get the latest state values and to re-render when state changes.
   */
  const select = (0, _reactRedux.createSelectorHook)( /*#__PURE__*/(0, _react.createContext)({
    store,
    storeState: store.getState()
  }));
  return {
    store,
    select,
    dispatch,
    getState: store.getState,
    onStateChange: store.subscribe
  };
};
exports.createReduxTools = createReduxTools;