"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PainlessLabUIPlugin = void 0;
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _constants = require("../common/constants");
var _links = require("./links");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const checkLicenseStatus = license => {
  const {
    state,
    message
  } = license.check(_constants.PLUGIN.id, _constants.PLUGIN.minimumLicenseType);
  return state === 'valid' ? {
    valid: true
  } : {
    valid: false,
    message
  };
};
class PainlessLabUIPlugin {
  setup({
    http,
    getStartServices,
    uiSettings
  }, {
    devTools,
    home,
    licensing
  }) {
    home.featureCatalogue.register({
      id: _constants.PLUGIN.id,
      title: _i18n.i18n.translate('xpack.painlessLab.registryProviderTitle', {
        defaultMessage: 'Painless Lab (beta)'
      }),
      description: _i18n.i18n.translate('xpack.painlessLab.registryProviderDescription', {
        defaultMessage: 'Simulate and debug painless code.'
      }),
      icon: 'empty',
      path: '/app/dev_tools#/painless_lab',
      showOnHomePage: false,
      category: 'admin'
    });
    const devTool = devTools.register({
      id: 'painless_lab',
      order: 7,
      isBeta: true,
      title: _i18n.i18n.translate('xpack.painlessLab.displayName', {
        defaultMessage: 'Painless Lab'
      }),
      enableRouting: false,
      disabled: false,
      mount: async ({
        element,
        theme$
      }) => {
        const [core] = await getStartServices();
        const {
          i18n: {
            Context: I18nContext
          },
          notifications,
          docLinks,
          chrome,
          settings
        } = core;
        const license = await (0, _rxjs.firstValueFrom)(licensing.license$);
        const licenseStatus = checkLicenseStatus(license);
        if (!licenseStatus.valid) {
          notifications.toasts.addDanger(licenseStatus.message);
          window.location.hash = '/dev_tools';
          return () => {};
        }
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        const tearDownApp = renderApp(element, {
          I18nContext,
          http,
          uiSettings,
          links: (0, _links.getLinks)(docLinks),
          chrome,
          theme$,
          settings
        });
        return () => {
          tearDownApp();
        };
      }
    });
    licensing.license$.subscribe(license => {
      if (!checkLicenseStatus(license).valid && !devTool.isDisabled()) {
        devTool.disable();
      } else if (devTool.isDisabled()) {
        devTool.enable();
      }
    });
  }
  start() {}
  stop() {}
}
exports.PainlessLabUIPlugin = PainlessLabUIPlugin;