"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentsRoute = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _lodash = require("lodash");
var _semver = require("semver");
var _aggregations = require("../../../common/utils/aggregations");
var _utils = require("../utils");
var _api = require("../../../common/api");
var _route_validation = require("../../utils/build_validation/route_validation");
var _constants = require("../../../common/constants");
var _common2 = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAgentsRoute = (router, osqueryContext) => {
  router.versioned.get({
    access: 'internal',
    path: '/internal/osquery/fleet_wrapper/agents',
    options: {
      tags: [`access:${_common2.PLUGIN_ID}-read`]
    }
  }).addVersion({
    version: _constants.API_VERSIONS.internal.v1,
    validate: {
      request: {
        query: (0, _route_validation.buildRouteValidation)(_api.getAgentsRequestQuerySchema)
      }
    }
  }, async (context, request, response) => {
    var _await$packagePolicyS, _esAgents, _esAgents$total, _esAgents2, _esAgents$agents, _esAgents3;
    let esAgents;
    const query = request.query;
    try {
      var _osqueryContext$servi;
      esAgents = await ((_osqueryContext$servi = osqueryContext.service.getAgentService()) === null || _osqueryContext$servi === void 0 ? void 0 : _osqueryContext$servi.asInternalUser.listAgents({
        page: query.page,
        perPage: query.perPage,
        sortField: query.sortField,
        sortOrder: query.sortOrder,
        showUpgradeable: query.showUpgradeable,
        getStatusSummary: query.getStatusSummary,
        pitId: query.pitId,
        searchAfter: query.searchAfter,
        kuery: query.kuery,
        showInactive: query.showInactive,
        aggregations: {
          platforms: {
            terms: {
              field: 'local_metadata.os.platform'
            }
          },
          policies: {
            terms: {
              field: 'policy_id',
              size: 2000
            }
          }
        }
      }));
    } catch (error) {
      return response.badRequest({
        body: error
      });
    }
    const internalSavedObjectsClient = await (0, _utils.getInternalSavedObjectsClient)(osqueryContext.getStartServices);
    const packagePolicyService = osqueryContext.service.getPackagePolicyService();
    const agentPolicyService = osqueryContext.service.getAgentPolicyService();
    const {
      items: packagePolicies
    } = (_await$packagePolicyS = await (packagePolicyService === null || packagePolicyService === void 0 ? void 0 : packagePolicyService.list(internalSavedObjectsClient, {
      kuery: `${_common.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name:${_constants.OSQUERY_INTEGRATION_NAME}`,
      perPage: 1000,
      page: 1
    }))) !== null && _await$packagePolicyS !== void 0 ? _await$packagePolicyS : {
      items: []
    };
    const supportedPackagePolicyIds = (0, _lodash.filter)(packagePolicies, packagePolicy => {
      var _packagePolicy$packag, _packagePolicy$packag2;
      return (0, _semver.satisfies)((_packagePolicy$packag = (_packagePolicy$packag2 = packagePolicy.package) === null || _packagePolicy$packag2 === void 0 ? void 0 : _packagePolicy$packag2.version) !== null && _packagePolicy$packag !== void 0 ? _packagePolicy$packag : '', '>=0.6.0');
    });
    const agentPolicyIds = (0, _lodash.uniq)((0, _lodash.map)(supportedPackagePolicyIds, 'policy_id'));
    const agentPolicies = await (agentPolicyService === null || agentPolicyService === void 0 ? void 0 : agentPolicyService.getByIds(internalSavedObjectsClient, agentPolicyIds));
    const agentPolicyById = (0, _lodash.mapKeys)(agentPolicies, 'id');
    const {
      platforms,
      overlap,
      policies
    } = (0, _aggregations.processAggregations)((_esAgents = esAgents) === null || _esAgents === void 0 ? void 0 : _esAgents.aggregations);
    return response.ok({
      body: {
        total: (_esAgents$total = (_esAgents2 = esAgents) === null || _esAgents2 === void 0 ? void 0 : _esAgents2.total) !== null && _esAgents$total !== void 0 ? _esAgents$total : 0,
        groups: {
          platforms,
          overlap,
          policies: policies.map(p => {
            var _agentPolicyById$p$id, _agentPolicyById$p$id2;
            const name = (_agentPolicyById$p$id = (_agentPolicyById$p$id2 = agentPolicyById[p.id]) === null || _agentPolicyById$p$id2 === void 0 ? void 0 : _agentPolicyById$p$id2.name) !== null && _agentPolicyById$p$id !== void 0 ? _agentPolicyById$p$id : p.name;
            return {
              ...p,
              name
            };
          })
        },
        agents: (_esAgents$agents = (_esAgents3 = esAgents) === null || _esAgents3 === void 0 ? void 0 : _esAgents3.agents) !== null && _esAgents$agents !== void 0 ? _esAgents$agents : []
      }
    });
  });
};
exports.getAgentsRoute = getAgentsRoute;