"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.OsqueryActionResult = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactQuery = require("@tanstack/react-query");
var _empty_prompt = require("../../routes/components/empty_prompt");
var _kibana = require("../../common/lib/kibana");
var _query_client = require("../../query_client");
var _contexts = require("../../common/contexts");
var _pack_queries_status_table = require("../../live_queries/form/pack_queries_status_table");
var _translations = require("../../agents/translations");
var _use_live_query_details = require("../../actions/use_live_query_details");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line react/display-name
const OsqueryResultComponent = /*#__PURE__*/_react.default.memo(({
  actionId,
  ruleName,
  startDate,
  ecsData
}) => {
  const {
    read
  } = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  const [isLive, setIsLive] = (0, _react.useState)(false);
  const {
    data
  } = (0, _use_live_query_details.useLiveQueryDetails)({
    actionId,
    isLive,
    skip: !read
  });
  (0, _react.useEffect)(() => {
    setIsLive(() => !((data === null || data === void 0 ? void 0 : data.status) === 'completed'));
  }, [data === null || data === void 0 ? void 0 : data.status]);
  return /*#__PURE__*/_react.default.createElement(_contexts.AlertAttachmentContext.Provider, {
    value: ecsData
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComment, {
    username: ruleName,
    timestamp: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
      value: startDate
    }),
    event: _translations.ATTACHED_QUERY,
    "data-test-subj": 'osquery-results-comment'
  }, !read ? /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, null) : /*#__PURE__*/_react.default.createElement(_pack_queries_status_table.PackQueriesStatusTable, {
    actionId: actionId,
    data: data === null || data === void 0 ? void 0 : data.queries,
    startDate: data === null || data === void 0 ? void 0 : data['@timestamp'],
    expirationDate: data === null || data === void 0 ? void 0 : data.expiration,
    agentIds: data === null || data === void 0 ? void 0 : data.agents
  })));
});
const OsqueryActionResult = /*#__PURE__*/_react.default.memo(OsqueryResultComponent);
exports.OsqueryActionResult = OsqueryActionResult;
const OsqueryActionResultWrapperComponent = ({
  services,
  ...restProps
}) => /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
  theme$: services.theme.theme$
}, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
  services: services
}, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
  client: _query_client.queryClient
}, /*#__PURE__*/_react.default.createElement(OsqueryActionResult, restProps)))));
const OsqueryActionResultWrapper = /*#__PURE__*/_react.default.memo(OsqueryActionResultWrapperComponent);

// eslint-disable-next-line import/no-default-export
exports.default = OsqueryActionResultWrapper;