"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewSavedQueryPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../../common/lib/kibana");
var _layouts = require("../../../components/layouts");
var _use_breadcrumbs = require("../../../common/hooks/use_breadcrumbs");
var _form = require("./form");
var _use_create_saved_query = require("../../../saved_queries/use_create_saved_query");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NewSavedQueryPageComponent = () => {
  (0, _use_breadcrumbs.useBreadcrumbs)('saved_query_new');
  const savedQueryListProps = (0, _kibana.useRouterNavigate)('saved_queries');
  const {
    mutateAsync
  } = (0, _use_create_saved_query.useCreateSavedQuery)({
    withRedirect: true
  });
  const LeftColumn = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    iconType: "arrowLeft"
  }, savedQueryListProps, {
    flush: "left",
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.addSavedQuery.viewSavedQueriesListTitle",
    defaultMessage: "View all saved queries"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.addSavedQuery.pageTitle",
    defaultMessage: "Add saved query"
  }))))), [savedQueryListProps]);
  const handleSubmit = (0, _react.useCallback)(async payload => {
    await mutateAsync(payload);
  }, [mutateAsync]);
  return /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    leftColumn: LeftColumn
  }, /*#__PURE__*/_react.default.createElement(_form.NewSavedQueryForm, {
    handleSubmit: handleSubmit
  }));
};
const NewSavedQueryPage = /*#__PURE__*/_react.default.memo(NewSavedQueryPageComponent);
exports.NewSavedQueryPage = NewSavedQueryPage;