"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateLiveQuery = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../common/constants");
var _kibana = require("../common/lib/kibana");
var _use_error_toast = require("../common/hooks/use_error_toast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCreateLiveQuery = ({
  onSuccess
}) => {
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  const {
    executionContext,
    http
  } = (0, _kibana.useKibana)().services;
  const queryExecutionContext = executionContext === null || executionContext === void 0 ? void 0 : executionContext.get();
  return (0, _reactQuery.useMutation)(async ({
    agentSelection,
    ...payload
  }) => {
    const response = await http.post('/api/osquery/live_queries', {
      version: _constants.API_VERSIONS.public.v1,
      body: JSON.stringify({
        ...payload,
        agent_all: agentSelection.allAgentsSelected,
        agent_ids: agentSelection.agents,
        agent_platforms: agentSelection.platformsSelected,
        agent_policy_ids: agentSelection.policiesSelected,
        metadata: {
          execution_context: queryExecutionContext
        }
      })
    });
    return response === null || response === void 0 ? void 0 : response.data;
  }, {
    onSuccess: () => {
      setErrorToast();
      if (onSuccess) {
        onSuccess();
      }
    },
    onError: error => {
      setErrorToast(error, {
        title: error.body.error,
        toastMessage: error.body.message
      });
    }
  });
};
exports.useCreateLiveQuery = useCreateLiveQuery;