"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RESULTS_INDEX = exports.QUERY_TIMEOUT = exports.OSQUERY_LOGS_BASE = exports.OSQUERY_INTEGRATION_NAME = exports.OSQUERY_ACTIONS_INDEX = exports.DEFAULT_PLATFORM = exports.DEFAULT_MAX_TABLE_QUERY_SIZE = exports.DEFAULT_DARK_MODE = exports.CASE_ATTACHMENT_TYPE_ID = exports.BASE_PATH = exports.API_VERSIONS = exports.ACTION_RESPONSES_INDEX = exports.ACTIONS_INDEX = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_MAX_TABLE_QUERY_SIZE = 10000;
exports.DEFAULT_MAX_TABLE_QUERY_SIZE = DEFAULT_MAX_TABLE_QUERY_SIZE;
const DEFAULT_DARK_MODE = 'theme:darkMode';
exports.DEFAULT_DARK_MODE = DEFAULT_DARK_MODE;
const OSQUERY_INTEGRATION_NAME = 'osquery_manager';
exports.OSQUERY_INTEGRATION_NAME = OSQUERY_INTEGRATION_NAME;
const BASE_PATH = '/app/osquery';
exports.BASE_PATH = BASE_PATH;
const OSQUERY_LOGS_BASE = `.logs-${OSQUERY_INTEGRATION_NAME}`;
exports.OSQUERY_LOGS_BASE = OSQUERY_LOGS_BASE;
const ACTIONS_INDEX = `${OSQUERY_LOGS_BASE}.actions`;
exports.ACTIONS_INDEX = ACTIONS_INDEX;
const RESULTS_INDEX = `${OSQUERY_LOGS_BASE}.results`;
exports.RESULTS_INDEX = RESULTS_INDEX;
const OSQUERY_ACTIONS_INDEX = `${ACTIONS_INDEX}-*`;
exports.OSQUERY_ACTIONS_INDEX = OSQUERY_ACTIONS_INDEX;
const ACTION_RESPONSES_INDEX = `.logs-${OSQUERY_INTEGRATION_NAME}.action.responses`;
exports.ACTION_RESPONSES_INDEX = ACTION_RESPONSES_INDEX;
const DEFAULT_PLATFORM = 'linux,windows,darwin';
exports.DEFAULT_PLATFORM = DEFAULT_PLATFORM;
const CASE_ATTACHMENT_TYPE_ID = 'osquery';
exports.CASE_ATTACHMENT_TYPE_ID = CASE_ATTACHMENT_TYPE_ID;
const API_VERSIONS = {
  public: {
    v1: '2023-10-31'
  },
  internal: {
    v1: '1'
  }
};
exports.API_VERSIONS = API_VERSIONS;
let QUERY_TIMEOUT;
exports.QUERY_TIMEOUT = QUERY_TIMEOUT;
(function (QUERY_TIMEOUT) {
  QUERY_TIMEOUT[QUERY_TIMEOUT["DEFAULT"] = 60] = "DEFAULT";
  QUERY_TIMEOUT[QUERY_TIMEOUT["MAX"] = 900] = "MAX";
})(QUERY_TIMEOUT || (exports.QUERY_TIMEOUT = QUERY_TIMEOUT = {}));