"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VersionOrUndefined = exports.Version = exports.StringArrayOrUndefined = exports.SortOrderOrUndefined = exports.SortOrUndefined = exports.SnapshotOrUndefined = exports.Snapshot = exports.Shards = exports.SavedQueryIdOrUndefined = exports.SavedQueryId = exports.RemovedOrUndefined = exports.Removed = exports.QueryOrUndefined = exports.Query = exports.QueriesOrUndefined = exports.Queries = exports.PolicyIdsOrUndefined = exports.PolicyIds = exports.PlatformOrUndefined = exports.Platform = exports.PageSizeOrUndefined = exports.PageOrUndefined = exports.PackName = exports.PackIdOrUndefined = exports.PackId = exports.ObjectQueriesItem = exports.ObjectQueries = exports.KueryOrUndefined = exports.IntervalOrUndefined = exports.Interval = exports.IdOrUndefined = exports.Id = exports.ExecutionContextOrUndefined = exports.ExecutionContext = exports.EnabledOrUndefined = exports.Enabled = exports.ECSMappingOrUndefined = exports.ECSMappingItem = exports.ECSMapping = exports.DescriptionOrUndefined = exports.Description = exports.ArrayQueriesItem = exports.ArrayQueries = exports.AgentSelectionOrUndefined = exports.AgentSelection = void 0;
var _zod = require("zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 */

const Id = _zod.z.string();
exports.Id = Id;
const IdOrUndefined = Id.nullable();
exports.IdOrUndefined = IdOrUndefined;
const AgentSelection = _zod.z.object({
  agents: _zod.z.array(_zod.z.string()).optional(),
  allAgentsSelected: _zod.z.boolean().optional(),
  platformsSelected: _zod.z.array(_zod.z.string()).optional(),
  policiesSelected: _zod.z.array(_zod.z.string()).optional()
});
exports.AgentSelection = AgentSelection;
const AgentSelectionOrUndefined = AgentSelection.nullable();
exports.AgentSelectionOrUndefined = AgentSelectionOrUndefined;
const Description = _zod.z.string();
exports.Description = Description;
const DescriptionOrUndefined = Description.nullable();
exports.DescriptionOrUndefined = DescriptionOrUndefined;
const Platform = _zod.z.string();
exports.Platform = Platform;
const PlatformOrUndefined = Platform.nullable();
exports.PlatformOrUndefined = PlatformOrUndefined;
const Query = _zod.z.string();
exports.Query = Query;
const QueryOrUndefined = Query.nullable();
exports.QueryOrUndefined = QueryOrUndefined;
const Version = _zod.z.string();
exports.Version = Version;
const VersionOrUndefined = Version.nullable();
exports.VersionOrUndefined = VersionOrUndefined;
const Interval = _zod.z.string();
exports.Interval = Interval;
const IntervalOrUndefined = Interval.nullable();
exports.IntervalOrUndefined = IntervalOrUndefined;
const Snapshot = _zod.z.boolean();
exports.Snapshot = Snapshot;
const SnapshotOrUndefined = Snapshot.nullable();
exports.SnapshotOrUndefined = SnapshotOrUndefined;
const Removed = _zod.z.boolean();
exports.Removed = Removed;
const RemovedOrUndefined = Removed.nullable();
exports.RemovedOrUndefined = RemovedOrUndefined;
const PackName = _zod.z.string();
exports.PackName = PackName;
const SavedQueryId = _zod.z.string();
exports.SavedQueryId = SavedQueryId;
const SavedQueryIdOrUndefined = SavedQueryId.nullable();
exports.SavedQueryIdOrUndefined = SavedQueryIdOrUndefined;
const PackId = _zod.z.string();
exports.PackId = PackId;
const PackIdOrUndefined = PackId.nullable();
exports.PackIdOrUndefined = PackIdOrUndefined;
const Enabled = _zod.z.boolean();
exports.Enabled = Enabled;
const EnabledOrUndefined = Enabled.nullable();
exports.EnabledOrUndefined = EnabledOrUndefined;
const PolicyIds = _zod.z.array(_zod.z.string());
exports.PolicyIds = PolicyIds;
const PolicyIdsOrUndefined = PolicyIds.nullable();
exports.PolicyIdsOrUndefined = PolicyIdsOrUndefined;
const ExecutionContext = _zod.z.object({
  name: _zod.z.string().nullable().optional(),
  url: _zod.z.string().nullable().optional()
});
exports.ExecutionContext = ExecutionContext;
const ExecutionContextOrUndefined = ExecutionContext.nullable();
exports.ExecutionContextOrUndefined = ExecutionContextOrUndefined;
const ECSMappingItem = _zod.z.object({
  field: _zod.z.string().optional(),
  value: _zod.z.union([_zod.z.string(), _zod.z.array(_zod.z.string())]).optional()
});
exports.ECSMappingItem = ECSMappingItem;
const ECSMapping = _zod.z.object({}).catchall(ECSMappingItem);
exports.ECSMapping = ECSMapping;
const ECSMappingOrUndefined = ECSMapping.nullable();
exports.ECSMappingOrUndefined = ECSMappingOrUndefined;
const StringArrayOrUndefined = _zod.z.array(_zod.z.string().nullable());
exports.StringArrayOrUndefined = StringArrayOrUndefined;
const ArrayQueriesItem = _zod.z.object({
  id: Id.optional(),
  query: Query.optional(),
  ecs_mapping: ECSMappingOrUndefined.optional(),
  version: VersionOrUndefined.optional(),
  platform: PlatformOrUndefined.optional(),
  removed: RemovedOrUndefined.optional(),
  snapshot: SnapshotOrUndefined.optional()
});
exports.ArrayQueriesItem = ArrayQueriesItem;
const ArrayQueries = _zod.z.array(ArrayQueriesItem);
exports.ArrayQueries = ArrayQueries;
const ObjectQueriesItem = _zod.z.object({
  query: Query.optional(),
  id: Id.optional(),
  ecs_mapping: ECSMappingOrUndefined.optional(),
  version: VersionOrUndefined.optional(),
  platform: PlatformOrUndefined.optional(),
  saved_query_id: SavedQueryIdOrUndefined.optional(),
  removed: RemovedOrUndefined.optional(),
  snapshot: SnapshotOrUndefined.optional()
});
exports.ObjectQueriesItem = ObjectQueriesItem;
const ObjectQueries = _zod.z.object({}).catchall(ObjectQueriesItem);
exports.ObjectQueries = ObjectQueries;
const Queries = _zod.z.union([ArrayQueries, ObjectQueries]);
exports.Queries = Queries;
const QueriesOrUndefined = Queries.nullable();
exports.QueriesOrUndefined = QueriesOrUndefined;
const KueryOrUndefined = _zod.z.string().nullable();
exports.KueryOrUndefined = KueryOrUndefined;
const PageOrUndefined = _zod.z.number().int().nullable();
exports.PageOrUndefined = PageOrUndefined;
const PageSizeOrUndefined = _zod.z.number().int().nullable();
exports.PageSizeOrUndefined = PageSizeOrUndefined;
const SortOrUndefined = _zod.z.string().nullable();
exports.SortOrUndefined = SortOrUndefined;
const SortOrderOrUndefined = _zod.z.union([_zod.z.string().nullable(), _zod.z.unknown()]);
exports.SortOrderOrUndefined = SortOrderOrUndefined;
const Shards = _zod.z.object({}).catchall(_zod.z.number());
exports.Shards = Shards;