"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChartTheme = useChartTheme;
var _eui_charts_theme = require("@elastic/eui/dist/eui_charts_theme");
var _react = require("react");
var _use_theme = require("./use_theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useChartTheme() {
  const theme = (0, _use_theme.useTheme)();
  const baseChartTheme = theme.darkMode ? _eui_charts_theme.EUI_CHARTS_THEME_DARK.theme : _eui_charts_theme.EUI_CHARTS_THEME_LIGHT.theme;
  return (0, _react.useMemo)(() => [{
    chartMargins: {
      left: 10,
      right: 10,
      top: 35,
      bottom: 10
    },
    background: {
      color: 'transparent'
    },
    lineSeriesStyle: {
      point: {
        visible: false
      }
    },
    areaSeriesStyle: {
      point: {
        visible: false
      }
    }
  }, baseChartTheme], [baseChartTheme]);
}