"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilingEmbeddable = ProfilingEmbeddable;
var _react = require("@emotion/react");
var _public = require("@kbn/kibana-react-plugin/public");
var _react2 = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ProfilingEmbeddable({
  embeddableFactoryId,
  data,
  isLoading,
  height,
  ...props
}) {
  const {
    embeddable: embeddablePlugin
  } = (0, _public.useKibana)().services;
  const [embeddable, setEmbeddable] = (0, _react2.useState)();
  const embeddableRoot = (0, _react2.useRef)(null);
  (0, _react2.useEffect)(() => {
    async function createEmbeddable() {
      const factory = embeddablePlugin === null || embeddablePlugin === void 0 ? void 0 : embeddablePlugin.getEmbeddableFactory(embeddableFactoryId);
      const input = {
        id: 'embeddable_profiling',
        data,
        isLoading
      };
      const embeddableObject = await (factory === null || factory === void 0 ? void 0 : factory.create(input));
      setEmbeddable(embeddableObject);
    }
    createEmbeddable();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react2.useEffect)(() => {
    if (embeddableRoot.current && embeddable) {
      embeddable.render(embeddableRoot.current);
    }
  }, [embeddable, embeddableRoot]);
  (0, _react2.useEffect)(() => {
    if (embeddable) {
      embeddable.updateInput({
        data,
        isLoading,
        ...props
      });
      embeddable.reload();
    }
  }, [data, embeddable, isLoading, props]);
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
        width: 100%;
        height: ${height};
        display: flex;
        flex: 1 1 100%;
        z-index: 1;
        min-height: 0;
      `,
    ref: embeddableRoot
  });
}