"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindSLO = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _errors = require("../../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGE = 1;
const DEFAULT_PER_PAGE = 25;
const MAX_PER_PAGE = 5000;
class FindSLO {
  constructor(repository, summarySearchClient) {
    this.repository = repository;
    this.summarySearchClient = summarySearchClient;
  }
  async execute(params) {
    var _params$kqlQuery;
    const sloSummaryList = await this.summarySearchClient.search((_params$kqlQuery = params.kqlQuery) !== null && _params$kqlQuery !== void 0 ? _params$kqlQuery : '', toSort(params), toPagination(params));
    const sloList = await this.repository.findAllByIds(sloSummaryList.results.map(slo => slo.id));
    const sloListWithSummary = mergeSloWithSummary(sloList, sloSummaryList.results);
    return _sloSchema.findSLOResponseSchema.encode({
      page: sloSummaryList.page,
      perPage: sloSummaryList.perPage,
      total: sloSummaryList.total,
      results: sloListWithSummary
    });
  }
}
exports.FindSLO = FindSLO;
function mergeSloWithSummary(sloList, sloSummaryList) {
  return sloSummaryList.filter(sloSummary => sloList.some(s => s.id === sloSummary.id)).map(sloSummary => ({
    ...sloList.find(s => s.id === sloSummary.id),
    instanceId: sloSummary.instanceId,
    summary: sloSummary.summary
  }));
}
function toPagination(params) {
  const page = Number(params.page);
  const perPage = Number(params.perPage);
  if (!isNaN(perPage) && perPage > MAX_PER_PAGE) {
    throw new _errors.IllegalArgumentError(`perPage limit set to ${MAX_PER_PAGE}`);
  }
  return {
    page: !isNaN(page) && page >= 1 ? page : DEFAULT_PAGE,
    perPage: !isNaN(perPage) && perPage >= 1 ? perPage : DEFAULT_PER_PAGE
  };
}
function toSort(params) {
  var _params$sortBy, _params$sortDirection;
  return {
    field: (_params$sortBy = params.sortBy) !== null && _params$sortBy !== void 0 ? _params$sortBy : 'status',
    direction: (_params$sortDirection = params.sortDirection) !== null && _params$sortDirection !== void 0 ? _params$sortDirection : 'asc'
  };
}