"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.viewInAppUrlActionVariableDescription = exports.valueActionVariableDescription = exports.timestampActionVariableDescription = exports.tagsActionVariableDescription = exports.reasonActionVariableDescription = exports.orchestratorActionVariableDescription = exports.labelsActionVariableDescription = exports.hostActionVariableDescription = exports.groupByKeysActionVariableDescription = exports.containerActionVariableDescription = exports.cloudActionVariableDescription = exports.alertDetailUrlActionVariableDescription = exports.SUM_I18N = exports.NOT_BETWEEN_TEXT = exports.MIN_I18N = exports.MAX_I18N = exports.DOCUMENT_COUNT_I18N = exports.CUSTOM_EQUATION_I18N = exports.CARDINALITY_I18N = exports.BETWEEN_TEXT = exports.BELOW_TEXT = exports.AVERAGE_I18N = exports.ABOVE_TEXT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DOCUMENT_COUNT_I18N = _i18n.i18n.translate('xpack.observability.customThreshold.rule.aggregators.documentCount', {
  defaultMessage: 'Document count'
});
exports.DOCUMENT_COUNT_I18N = DOCUMENT_COUNT_I18N;
const AVERAGE_I18N = metric => _i18n.i18n.translate('xpack.observability.customThreshold.rule.aggregators.average', {
  defaultMessage: 'Average {metric}',
  values: {
    metric
  }
});
exports.AVERAGE_I18N = AVERAGE_I18N;
const MAX_I18N = metric => _i18n.i18n.translate('xpack.observability.customThreshold.rule.aggregators.max', {
  defaultMessage: 'Max {metric}',
  values: {
    metric
  }
});
exports.MAX_I18N = MAX_I18N;
const MIN_I18N = metric => _i18n.i18n.translate('xpack.observability.customThreshold.rule.aggregators.min', {
  defaultMessage: 'Min {metric}',
  values: {
    metric
  }
});
exports.MIN_I18N = MIN_I18N;
const CARDINALITY_I18N = metric => _i18n.i18n.translate('xpack.observability.customThreshold.rule.aggregators.cardinality', {
  defaultMessage: 'Cardinality of the {metric}',
  values: {
    metric
  }
});
exports.CARDINALITY_I18N = CARDINALITY_I18N;
const SUM_I18N = metric => _i18n.i18n.translate('xpack.observability.customThreshold.rule.aggregators.sum', {
  defaultMessage: 'Sum of the {metric}',
  values: {
    metric
  }
});
exports.SUM_I18N = SUM_I18N;
const CUSTOM_EQUATION_I18N = _i18n.i18n.translate('xpack.observability.customThreshold.rule.aggregators.customEquation', {
  defaultMessage: 'Custom equation'
});

// Comparators
exports.CUSTOM_EQUATION_I18N = CUSTOM_EQUATION_I18N;
const BELOW_TEXT = _i18n.i18n.translate('xpack.observability.customThreshold.rule.threshold.below', {
  defaultMessage: 'below'
});
exports.BELOW_TEXT = BELOW_TEXT;
const ABOVE_TEXT = _i18n.i18n.translate('xpack.observability.customThreshold.rule.threshold.above', {
  defaultMessage: 'above'
});
exports.ABOVE_TEXT = ABOVE_TEXT;
const BETWEEN_TEXT = _i18n.i18n.translate('xpack.observability.customThreshold.rule.threshold.between', {
  defaultMessage: 'between'
});
exports.BETWEEN_TEXT = BETWEEN_TEXT;
const NOT_BETWEEN_TEXT = _i18n.i18n.translate('xpack.observability.customThreshold.rule.threshold.notBetween', {
  defaultMessage: 'not between'
});

// Action variable descriptions
exports.NOT_BETWEEN_TEXT = NOT_BETWEEN_TEXT;
const groupByKeysActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.groupByKeysActionVariableDescription', {
  defaultMessage: 'The object containing groups that are reporting data'
});
exports.groupByKeysActionVariableDescription = groupByKeysActionVariableDescription;
const alertDetailUrlActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertDetailUrlActionVariableDescription', {
  defaultMessage: 'Link to the alert troubleshooting view for further context and details. This will be an empty string if the server.publicBaseUrl is not configured.'
});
exports.alertDetailUrlActionVariableDescription = alertDetailUrlActionVariableDescription;
const reasonActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.reasonActionVariableDescription', {
  defaultMessage: 'A concise description of the reason for the alert'
});
exports.reasonActionVariableDescription = reasonActionVariableDescription;
const timestampActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.timestampDescription', {
  defaultMessage: 'A timestamp of when the alert was detected.'
});
exports.timestampActionVariableDescription = timestampActionVariableDescription;
const valueActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.valueActionVariableDescription', {
  defaultMessage: 'List of the condition values.'
});
exports.valueActionVariableDescription = valueActionVariableDescription;
const viewInAppUrlActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.viewInAppUrlActionVariableDescription', {
  defaultMessage: 'Link to the alert source'
});
exports.viewInAppUrlActionVariableDescription = viewInAppUrlActionVariableDescription;
const cloudActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.cloudActionVariableDescription', {
  defaultMessage: 'The cloud object defined by ECS if available in the source.'
});
exports.cloudActionVariableDescription = cloudActionVariableDescription;
const hostActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.hostActionVariableDescription', {
  defaultMessage: 'The host object defined by ECS if available in the source.'
});
exports.hostActionVariableDescription = hostActionVariableDescription;
const containerActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.containerActionVariableDescription', {
  defaultMessage: 'The container object defined by ECS if available in the source.'
});
exports.containerActionVariableDescription = containerActionVariableDescription;
const orchestratorActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.orchestratorActionVariableDescription', {
  defaultMessage: 'The orchestrator object defined by ECS if available in the source.'
});
exports.orchestratorActionVariableDescription = orchestratorActionVariableDescription;
const labelsActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.labelsActionVariableDescription', {
  defaultMessage: 'List of labels associated with the entity where this alert triggered.'
});
exports.labelsActionVariableDescription = labelsActionVariableDescription;
const tagsActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.tagsActionVariableDescription', {
  defaultMessage: 'List of tags associated with the entity where this alert triggered.'
});
exports.tagsActionVariableDescription = tagsActionVariableDescription;