"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchConfigurationSchema = exports.MetricsRulesTypeAlertDefinition = void 0;
exports.thresholdRuleType = thresholdRuleType;
var _server = require("@kbn/core/server");
var _configSchema = require("@kbn/config-schema");
var _common = require("@kbn/data-plugin/common");
var _schema = require("@kbn/data-views-plugin/server/rest_api_routes/schema");
var _i18n = require("@kbn/i18n");
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common2 = require("../../../../common");
var _types = require("../../../../common/custom_threshold_rule/types");
var _constants = require("../../../common/constants");
var _translations = require("./translations");
var _utils = require("./utils");
var _custom_threshold_executor = require("./custom_threshold_executor");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsRulesTypeAlertDefinition = {
  context: _constants.THRESHOLD_RULE_REGISTRATION_CONTEXT,
  mappings: {
    fieldMap: _alertsAsDataUtils.legacyExperimentalFieldMap
  },
  useEcs: true,
  useLegacyAlerts: false
};
exports.MetricsRulesTypeAlertDefinition = MetricsRulesTypeAlertDefinition;
const searchConfigurationSchema = _configSchema.schema.object({
  index: _configSchema.schema.oneOf([_configSchema.schema.string(), _schema.dataViewSpecSchema]),
  query: _configSchema.schema.object({
    language: _configSchema.schema.string({
      validate: _utils.validateKQLStringFilter
    }),
    query: _configSchema.schema.string()
  })
});
exports.searchConfigurationSchema = searchConfigurationSchema;
function thresholdRuleType(createLifecycleRuleExecutor, basePath, config, logger, ruleDataClient, locators) {
  const baseCriterion = {
    threshold: _configSchema.schema.arrayOf(_configSchema.schema.number()),
    comparator: (0, _utils.oneOfLiterals)(Object.values(_types.Comparator)),
    timeUnit: _configSchema.schema.string(),
    timeSize: _configSchema.schema.number()
  };
  const customCriterion = _configSchema.schema.object({
    ...baseCriterion,
    aggType: _configSchema.schema.maybe(_configSchema.schema.literal('custom')),
    metric: _configSchema.schema.never(),
    metrics: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.object({
      name: _configSchema.schema.string(),
      aggType: (0, _utils.oneOfLiterals)(['avg', 'sum', 'max', 'min', 'cardinality']),
      field: _configSchema.schema.string(),
      filter: _configSchema.schema.never()
    }), _configSchema.schema.object({
      name: _configSchema.schema.string(),
      aggType: _configSchema.schema.literal('count'),
      filter: _configSchema.schema.maybe(_configSchema.schema.string({
        validate: _utils.validateKQLStringFilter
      })),
      field: _configSchema.schema.never()
    })])),
    equation: _configSchema.schema.maybe(_configSchema.schema.string()),
    label: _configSchema.schema.maybe(_configSchema.schema.string())
  });
  return {
    id: _ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID,
    name: _i18n.i18n.translate('xpack.observability.threshold.ruleName', {
      defaultMessage: 'Custom threshold (Beta)'
    }),
    fieldsForAAD: _constants2.CUSTOM_THRESHOLD_AAD_FIELDS,
    validate: {
      params: _configSchema.schema.object({
        criteria: _configSchema.schema.arrayOf(customCriterion),
        groupBy: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())])),
        alertOnNoData: _configSchema.schema.maybe(_configSchema.schema.boolean()),
        alertOnGroupDisappear: _configSchema.schema.maybe(_configSchema.schema.boolean()),
        searchConfiguration: searchConfigurationSchema
      }, {
        unknowns: 'allow'
      })
    },
    defaultActionGroupId: _constants2.FIRED_ACTION.id,
    actionGroups: [_constants2.FIRED_ACTION, _constants2.NO_DATA_ACTION],
    minimumLicenseRequired: 'basic',
    isExportable: true,
    executor: createLifecycleRuleExecutor((0, _custom_threshold_executor.createCustomThresholdExecutor)({
      basePath,
      logger,
      config,
      locators
    })),
    doesSetRecoveryContext: true,
    actionVariables: {
      context: [{
        name: 'group',
        description: _translations.groupByKeysActionVariableDescription
      }, {
        name: 'alertDetailsUrl',
        description: _translations.alertDetailUrlActionVariableDescription,
        usesPublicBaseUrl: true
      }, {
        name: 'reason',
        description: _translations.reasonActionVariableDescription
      }, {
        name: 'timestamp',
        description: _translations.timestampActionVariableDescription
      }, {
        name: 'value',
        description: _translations.valueActionVariableDescription
      }, {
        name: 'cloud',
        description: _translations.cloudActionVariableDescription
      }, {
        name: 'host',
        description: _translations.hostActionVariableDescription
      }, {
        name: 'container',
        description: _translations.containerActionVariableDescription
      }, {
        name: 'orchestrator',
        description: _translations.orchestratorActionVariableDescription
      }, {
        name: 'labels',
        description: _translations.labelsActionVariableDescription
      }, {
        name: 'tags',
        description: _translations.tagsActionVariableDescription
      }, {
        name: 'viewInAppUrl',
        description: _translations.viewInAppUrlActionVariableDescription
      }]
    },
    useSavedObjectReferences: {
      // TODO revisit types https://github.com/elastic/kibana/issues/159714
      extractReferences: params => {
        const [searchConfiguration, references] = (0, _common.extractReferences)(params.searchConfiguration);
        const newParams = {
          ...params,
          searchConfiguration
        };
        return {
          params: newParams,
          references
        };
      },
      injectReferences: (params, references) => {
        return {
          ...params,
          searchConfiguration: (0, _common.injectReferences)(params.searchConfiguration, references)
        };
      }
    },
    category: _server.DEFAULT_APP_CATEGORIES.observability.id,
    producer: _common2.observabilityFeatureId,
    alerts: MetricsRulesTypeAlertDefinition,
    getViewInAppRelativeUrl: ({
      rule
    }) => _common2.observabilityPaths.ruleDetails(rule.id)
  };
}