"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSLOTransformTemplate = void 0;
var _constants = require("../../../common/slo/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSLOTransformTemplate = (transformId, description, source, destination, groupBy = {}, aggregations = {}, settings) => ({
  transform_id: transformId,
  description,
  source,
  frequency: settings.frequency,
  dest: destination,
  settings: {
    deduce_mappings: false,
    unattended: true
  },
  sync: {
    time: {
      field: settings.sync_field,
      delay: settings.sync_delay
    }
  },
  pivot: {
    group_by: groupBy,
    aggregations
  },
  defer_validation: true,
  _meta: {
    version: _constants.SLO_RESOURCES_VERSION,
    managed: true,
    managed_by: 'observability'
  }
});
exports.getSLOTransformTemplate = getSLOTransformTemplate;