"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLO_LIST_SEARCH_URL_STORAGE_KEY = exports.DEFAULT_STATE = void 0;
exports.useUrlSearchState = useUrlSearchState;
var _public = require("@kbn/kibana-utils-plugin/public");
var _deepmerge = _interopRequireDefault(require("deepmerge"));
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../../common/slo/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SLO_LIST_SEARCH_URL_STORAGE_KEY = 'search';
exports.SLO_LIST_SEARCH_URL_STORAGE_KEY = SLO_LIST_SEARCH_URL_STORAGE_KEY;
const DEFAULT_STATE = {
  kqlQuery: '',
  page: 0,
  perPage: _constants.DEFAULT_SLO_PAGE_SIZE,
  sort: {
    by: 'status',
    direction: 'desc'
  },
  view: 'cardView',
  compact: true
};
exports.DEFAULT_STATE = DEFAULT_STATE;
function useUrlSearchState() {
  var _urlStateStorage$get;
  const history = (0, _reactRouterDom.useHistory)();
  const urlStateStorage = (0, _public.createKbnUrlStateStorage)({
    history,
    useHash: false,
    useHashQuery: false
  });
  const searchState = (_urlStateStorage$get = urlStateStorage.get(SLO_LIST_SEARCH_URL_STORAGE_KEY)) !== null && _urlStateStorage$get !== void 0 ? _urlStateStorage$get : DEFAULT_STATE;
  return {
    state: (0, _deepmerge.default)(DEFAULT_STATE, searchState),
    store: state => urlStateStorage.set(SLO_LIST_SEARCH_URL_STORAGE_KEY, (0, _deepmerge.default)(searchState, state), {
      replace: true
    })
  };
}