"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToggleSLOView = ToggleSLOView;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _slo_view_settings = require("./slo_view_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toggleButtonsIcons = [{
  id: `cardView`,
  label: 'Card View',
  iconType: 'visGauge',
  'data-test-subj': 'sloCardViewButton'
}, {
  id: `listView`,
  label: 'List View',
  iconType: 'list',
  'data-test-subj': 'sloListViewButton'
}];
function ToggleSLOView({
  sloView,
  onChangeView,
  onToggleCompactView,
  isCompact = true
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.observability.toggleSLOView.euiButtonGroup.sloView', {
      defaultMessage: 'SLO View'
    }),
    options: toggleButtonsIcons,
    idSelected: sloView,
    onChange: id => onChangeView(id),
    isIconOnly: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_slo_view_settings.SLOViewSettings, {
    toggleCompactView: onToggleCompactView,
    isCompact: isCompact
  })));
}