"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLOViewSettings = SLOViewSettings;
exports.SLO_LIST_IS_COMPACT = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SLO_LIST_IS_COMPACT = 'slo-list-is-compact';
exports.SLO_LIST_IS_COMPACT = SLO_LIST_IS_COMPACT;
function SLOViewSettings({
  toggleCompactView,
  isCompact
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.slo.listView.compactViewLabel",
      defaultMessage: "Compact view"
    }),
    id: "sloListCompactToggle",
    checked: isCompact,
    onChange: toggleCompactView,
    compressed: true
  });
}