"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloList = SloList;
var _eui = require("@elastic/eui");
var _reactQuery = require("@tanstack/react-query");
var _react = _interopRequireWildcard(require("react"));
var _use_fetch_slo_list = require("../../../hooks/slo/use_fetch_slo_list");
var _use_url_search_state = require("../hooks/use_url_search_state");
var _slos_view = require("./slos_view");
var _slo_list_search_bar = require("./slo_list_search_bar");
var _toggle_slo_view = require("./toggle_slo_view");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloList({
  autoRefresh
}) {
  const {
    state,
    store: storeState
  } = (0, _use_url_search_state.useUrlSearchState)();
  const [page, setPage] = (0, _react.useState)(state.page);
  const [perPage, setPerPage] = (0, _react.useState)(state.perPage);
  const [query, setQuery] = (0, _react.useState)(state.kqlQuery);
  const [sort, setSort] = (0, _react.useState)(state.sort.by);
  const [direction] = (0, _react.useState)(state.sort.direction);
  const [view, setView] = (0, _react.useState)(state.view);
  const [isCompact, setCompact] = (0, _react.useState)(state.compact);
  const {
    isLoading,
    isRefetching,
    isError,
    data: sloList
  } = (0, _use_fetch_slo_list.useFetchSloList)({
    perPage,
    page: page + 1,
    kqlQuery: query,
    sortBy: sort,
    sortDirection: direction,
    shouldRefetch: autoRefresh
  });
  const {
    results = [],
    total = 0
  } = sloList !== null && sloList !== void 0 ? sloList : {};
  const isCreatingSlo = Boolean((0, _reactQuery.useIsMutating)(['creatingSlo']));
  const isCloningSlo = Boolean((0, _reactQuery.useIsMutating)(['cloningSlo']));
  const isUpdatingSlo = Boolean((0, _reactQuery.useIsMutating)(['updatingSlo']));
  const isDeletingSlo = Boolean((0, _reactQuery.useIsMutating)(['deleteSlo']));
  const handlePageClick = pageNumber => {
    setPage(pageNumber);
    storeState({
      page: pageNumber
    });
  };
  const handleChangeQuery = newQuery => {
    setPage(0);
    setQuery(newQuery);
    storeState({
      page: 0,
      kqlQuery: newQuery
    });
  };
  const handleChangeSort = newSort => {
    setPage(0);
    setSort(newSort);
    storeState({
      page: 0,
      sort: {
        by: newSort,
        direction: state.sort.direction
      }
    });
  };
  const handleChangeView = newView => {
    setView(newView);
    storeState({
      view: newView
    });
  };
  const handleToggleCompactView = () => {
    const newCompact = !isCompact;
    setCompact(newCompact);
    storeState({
      compact: newCompact
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": "sloList"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_slo_list_search_bar.SloListSearchBar, {
    loading: isLoading || isCreatingSlo || isCloningSlo || isUpdatingSlo || isDeletingSlo,
    onChangeQuery: handleChangeQuery,
    onChangeSort: handleChangeSort,
    initialState: state
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_toggle_slo_view.ToggleSLOView, {
    sloView: view,
    onChangeView: handleChangeView,
    onToggleCompactView: handleToggleCompactView,
    isCompact: isCompact
  })), /*#__PURE__*/_react.default.createElement(_slos_view.SlosView, {
    sloList: results,
    loading: isLoading || isRefetching,
    error: isError,
    isCompact: isCompact,
    sloView: view
  }), total > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    pageCount: Math.ceil(total / perPage),
    activePage: page,
    onChangePage: handlePageClick,
    itemsPerPage: perPage,
    itemsPerPageOptions: [10, 25, 50, 100],
    onChangeItemsPerPage: newPerPage => {
      setPerPage(newPerPage);
      storeState({
        perPage: newPerPage
      });
    }
  })) : null);
}