"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CREATE_RULE_SEARCH_PARAM = void 0;
exports.useAddRuleFlyoutState = useAddRuleFlyoutState;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CREATE_RULE_SEARCH_PARAM = 'create-rule';
exports.CREATE_RULE_SEARCH_PARAM = CREATE_RULE_SEARCH_PARAM;
function useAddRuleFlyoutState(isEditMode) {
  const [isAddRuleFlyoutOpen, setIsAddRuleFlyoutOpen] = (0, _react.useState)(false);
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const searchParams = new URLSearchParams(search);
  if (searchParams.has(CREATE_RULE_SEARCH_PARAM) && isEditMode && !isAddRuleFlyoutOpen) {
    setIsAddRuleFlyoutOpen(true);
  }
  return isAddRuleFlyoutOpen;
}