"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CUSTOM_METRIC_AGGREGATION_OPTIONS = exports.AGGREGATION_OPTIONS = void 0;
exports.aggValueToLabel = aggValueToLabel;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGGREGATION_OPTIONS = [{
  value: 'avg',
  label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.timesliceMetric.aggregation.average', {
    defaultMessage: 'Average'
  })
}, {
  value: 'max',
  label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.timesliceMetric.aggregation.max', {
    defaultMessage: 'Max'
  })
}, {
  value: 'min',
  label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.timesliceMetric.aggregation.min', {
    defaultMessage: 'Min'
  })
}, {
  value: 'sum',
  label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.timesliceMetric.aggregation.sum', {
    defaultMessage: 'Sum'
  })
}, {
  value: 'cardinality',
  label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.timesliceMetric.aggregation.cardinality', {
    defaultMessage: 'Cardinality'
  })
}, {
  value: 'last_value',
  label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.timesliceMetric.aggregation.last_value', {
    defaultMessage: 'Last value'
  })
}, {
  value: 'std_deviation',
  label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.timesliceMetric.aggregation.std_deviation', {
    defaultMessage: 'Std. Deviation'
  })
}, {
  value: 'doc_count',
  label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.timesliceMetric.aggregation.doc_count', {
    defaultMessage: 'Doc count'
  })
}, {
  value: 'percentile',
  label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.timesliceMetric.aggregation.percentile', {
    defaultMessage: 'Percentile'
  })
}];
exports.AGGREGATION_OPTIONS = AGGREGATION_OPTIONS;
const CUSTOM_METRIC_AGGREGATION_OPTIONS = AGGREGATION_OPTIONS.filter(option => ['doc_count', 'sum'].includes(option.value));
exports.CUSTOM_METRIC_AGGREGATION_OPTIONS = CUSTOM_METRIC_AGGREGATION_OPTIONS;
function aggValueToLabel(value) {
  const aggregation = AGGREGATION_OPTIONS.find(agg => agg.value === value);
  if (aggregation) {
    return aggregation.label;
  }
  return value;
}