"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HistogramIndicator = HistogramIndicator;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _create_options = require("../../helpers/create_options");
var _query_builder = require("../common/query_builder");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGGREGATIONS = {
  value_count: {
    value: 'value_count',
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.histogram.valueCountLabel', {
      defaultMessage: 'Value count'
    })
  },
  range: {
    value: 'range',
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.histogram.rangeLabel', {
      defaultMessage: 'Range'
    })
  }
};
const AGGREGATION_OPTIONS = Object.values(AGGREGATIONS);
const aggregationTooltip = /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.histogram.aggregationTooltip', {
    defaultMessage: 'The "value count" aggreation will return the total count for the histogram field. Range will return the count from the histogram field that is within the range defined below.'
  }),
  position: "top"
});
const fromTooltip = /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.histogram.fromTooltip', {
    defaultMessage: 'The "from" value is inclusive.'
  }),
  position: "top"
});
const toTooltip = /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.histogram.toTooltip', {
    defaultMessage: 'The "to" value is NOT inclusive.'
  }),
  position: "top"
});
const aggregationLabel = _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.histogram.aggregationLabel', {
  defaultMessage: 'Aggregation'
});
const metricLabel = _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.histogram.metricLabel', {
  defaultMessage: 'Field'
});
const toLabel = _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.histogram.toLabel', {
  defaultMessage: 'To'
});
const fromLabel = _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.histogram.fromLabel', {
  defaultMessage: 'From'
});
function HistogramIndicator({
  type,
  histogramFields,
  isLoadingIndex
}) {
  const {
    control,
    watch,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const [options, setOptions] = (0, _react.useState)((0, _create_options.createOptionsFromFields)(histogramFields));
  (0, _react.useEffect)(() => {
    setOptions((0, _create_options.createOptionsFromFields)(histogramFields));
  }, [histogramFields]);
  const indexPattern = watch('indicator.params.index');
  const aggregation = watch(`indicator.params.${type}.aggregation`);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement("span", null, aggregationLabel, " ", aggregationTooltip)
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: `indicator.params.${type}.aggregation`,
    rules: {
      required: true
    },
    control: control,
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
      async: true,
      fullWidth: true,
      singleSelection: {
        asPlainText: true
      },
      placeholder: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.histogram.aggregation.placeholder', {
        defaultMessage: 'Select an aggregation'
      }),
      "aria-label": _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.histogram.aggregation.placeholder', {
        defaultMessage: 'Select an aggregation'
      }),
      isInvalid: fieldState.invalid,
      isDisabled: !indexPattern,
      isLoading: !!indexPattern && isLoadingIndex,
      onChange: selected => {
        if (selected.length) {
          return field.onChange(selected[0].value);
        }
        field.onChange('');
      },
      selectedOptions: !!field.value ? [AGGREGATIONS[field.value]] : [],
      options: AGGREGATION_OPTIONS
    }))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: getFieldState(`indicator.params.${type}.field`).invalid,
    label: /*#__PURE__*/_react.default.createElement("span", null, metricLabel)
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: `indicator.params.${type}.field`,
    defaultValue: "",
    rules: {
      required: true
    },
    control: control,
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
      async: true,
      fullWidth: true,
      singleSelection: {
        asPlainText: true
      },
      placeholder: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.histogram.metricField.placeholder', {
        defaultMessage: 'Select a histogram field'
      }),
      "aria-label": _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.histogram.metricField.placeholder', {
        defaultMessage: 'Select a histogram field'
      }),
      isInvalid: fieldState.invalid,
      isDisabled: isLoadingIndex || !indexPattern,
      isLoading: !!indexPattern && isLoadingIndex,
      onChange: selected => {
        if (selected.length) {
          return field.onChange(selected[0].value);
        }
        field.onChange('');
      },
      selectedOptions: !!indexPattern && !!field.value && histogramFields.some(histoField => histoField.name === field.value) ? [{
        value: field.value,
        label: field.value
      }] : [],
      onSearchChange: searchValue => {
        setOptions((0, _create_options.createOptionsFromFields)(histogramFields, ({
          value
        }) => value.includes(searchValue)));
      },
      options: options
    }))
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, aggregation === 'range' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement("span", null, fromLabel, " ", fromTooltip)
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: `indicator.params.${type}.from`,
    defaultValue: NaN,
    control: control,
    rules: {
      required: true
    },
    shouldUnregister: true,
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({}, field, {
      required: true,
      fullWidth: true,
      isInvalid: fieldState.invalid,
      value: String(field.value),
      "data-test-subj": "histogramRangeFrom",
      min: 0,
      onChange: event => field.onChange(Number(event.target.value))
    }))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement("span", null, toLabel, " ", toTooltip)
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: `indicator.params.${type}.to`,
    defaultValue: NaN,
    rules: {
      required: true
    },
    shouldUnregister: true,
    control: control,
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({}, field, {
      required: true,
      fullWidth: true,
      isInvalid: fieldState.invalid,
      value: String(field.value),
      "data-test-subj": "histogramRangeTo",
      min: 0,
      onChange: event => field.onChange(Number(event.target.value))
    }))
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_query_builder.QueryBuilder, {
    dataTestSubj: `histogramIndicatorForm${type}QueryInput`,
    indexPatternString: indexPattern,
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.histogram.kqlFilterLabel', {
      defaultMessage: 'KQL filter'
    }),
    name: `indicator.params.${type}.filter`,
    placeholder: "",
    required: false,
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.histogram.query.tooltip', {
        defaultMessage: 'This KQL query should return a subset of events for this indicator.'
      }),
      position: "top"
    })
  }))));
}