"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataPreviewChart = DataPreviewChart;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _kibana_react = require("../../../../utils/kibana_react");
var _use_preview = require("../../hooks/use_preview");
var _use_section_form_validation = require("../../hooks/use_section_form_validation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ONE_HOUR_IN_MILLISECONDS = 1 * 60 * 60 * 1000;
function DataPreviewChart({
  formatPattern,
  threshold,
  thresholdDirection,
  thresholdColor,
  thresholdMessage
}) {
  const {
    watch,
    getFieldState,
    formState,
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const {
    charts,
    uiSettings
  } = (0, _kibana_react.useKibana)().services;
  const {
    isIndicatorSectionValid
  } = (0, _use_section_form_validation.useSectionFormValidation)({
    getFieldState,
    getValues,
    formState,
    watch
  });
  const [range, _] = (0, _react.useState)({
    start: new Date().getTime() - ONE_HOUR_IN_MILLISECONDS,
    end: new Date().getTime()
  });
  const {
    data: previewData,
    isLoading: isPreviewLoading,
    isSuccess,
    isError
  } = (0, _use_preview.useDebouncedGetPreviewData)(isIndicatorSectionValid, watch('indicator'), range);
  const theme = charts.theme.useChartsTheme();
  const baseTheme = charts.theme.useChartsBaseTheme();
  const dateFormat = uiSettings.get('dateFormat');
  const numberFormat = formatPattern != null ? formatPattern : uiSettings.get('format:percent:defaultPattern');
  const values = (previewData || []).map(row => row.sliValue);
  const maxValue = (0, _lodash.max)(values);
  const minValue = (0, _lodash.min)(values);
  const domain = {
    fit: true,
    min: threshold != null && minValue != null && threshold < minValue ? threshold : minValue || NaN,
    max: threshold != null && maxValue != null && threshold > maxValue ? threshold : maxValue || NaN
  };
  const title = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.slo.sloEdit.dataPreviewChart.panelLabel",
    defaultMessage: "SLI preview"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
  if (!isIndicatorSectionValid) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, title, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true,
      hasShadow: false,
      style: {
        minHeight: 194
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      style: {
        minHeight: 160
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _i18n.i18n.translate('xpack.observability.slo.sloEdit.dataPreviewChart.explanationMessage', {
      defaultMessage: 'Fill the indicator fields to see visualisation of the current metrics'
    }))))));
  }
  const annotation = threshold != null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "thresholdAnnotation",
    domainType: _charts.AnnotationDomainType.YDomain,
    dataValues: [{
      dataValue: threshold
    }],
    style: {
      line: {
        strokeWidth: 2,
        stroke: thresholdColor || '#000',
        opacity: 1
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    dataValues: [{
      coordinates: thresholdDirection === 'above' ? {
        y0: threshold,
        y1: maxValue
      } : {
        y0: minValue,
        y1: threshold
      },
      details: thresholdMessage
    }],
    id: "thresholdShade",
    style: {
      fill: thresholdColor || '#000',
      opacity: 0.1
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, title, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    style: {
      minHeight: 194
    }
  }, (isPreviewLoading || isError) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    style: {
      height: 160
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isPreviewLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "m",
    mono: true
  }), isError && /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.observability.slo.sloEdit.dataPreviewChart.errorMessage', {
    defaultMessage: 'The current indicator settings are invalid'
  })))), isSuccess && /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 160,
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: "vertical"
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: baseTheme,
    showLegend: false,
    theme: [{
      ...theme,
      lineSeriesStyle: {
        point: {
          visible: false
        }
      }
    }],
    noResults: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "visualizeApp",
      size: "l",
      color: "subdued",
      title: "no results"
    }),
    locale: _i18n.i18n.getLocale()
  }), annotation, /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "y-axis",
    title: _i18n.i18n.translate('xpack.observability.slo.sloEdit.dataPreviewChart.yTitle', {
      defaultMessage: 'SLI'
    }),
    ticks: 5,
    position: _charts.Position.Left,
    tickFormat: d => (0, _numeral.default)(d).format(numberFormat),
    domain: domain
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "time",
    title: _i18n.i18n.translate('xpack.observability.slo.sloEdit.dataPreviewChart.xTitle', {
      defaultMessage: 'Last hour'
    }),
    tickFormat: d => (0, _moment.default)(d).format(dateFormat),
    position: _charts.Position.Bottom,
    timeAxisLayerCount: 2,
    gridLine: {
      visible: true
    },
    style: {
      tickLine: {
        size: 0.0001,
        padding: 4,
        visible: true
      },
      tickLabel: {
        alignment: {
          horizontal: _charts.Position.Left,
          vertical: _charts.Position.Bottom
        },
        padding: 0,
        offset: {
          x: 0,
          y: 0
        }
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: "SLI",
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "date",
    yAccessors: ['value'],
    data: (previewData !== null && previewData !== void 0 ? previewData : []).map(datum => ({
      date: new Date(datum.date).getTime(),
      value: datum.sliValue >= 0 ? datum.sliValue : null
    }))
  })))));
}