"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesPage = RulesPage;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/alerting-plugin/common");
var _public = require("@kbn/observability-shared-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _public2 = require("@kbn/triggers-actions-ui-plugin/public");
var _paths = require("../../../common/locators/paths");
var _kibana_react = require("../../utils/kibana_react");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_get_filtered_rule_types = require("../../hooks/use_get_filtered_rule_types");
var _constants = require("../../../common/constants");
var _header_menu = require("../overview/components/header_menu/header_menu");
var _rules_tab = require("./rules_tab");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const GlobalLogsTab = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./global_logs_tab'))));
const RULES_TAB_NAME = 'rules';
function RulesPage({
  activeTab = RULES_TAB_NAME
}) {
  const {
    http,
    docLinks,
    triggersActionsUi: {
      getAddRuleFlyout: AddRuleFlyout,
      getRulesSettingsLink: RulesSettingsLink
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const [addRuleFlyoutVisibility, setAddRuleFlyoutVisibility] = (0, _react.useState)(false);
  const [stateRefresh, setRefresh] = (0, _react.useState)(new Date());
  (0, _public.useBreadcrumbs)([{
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.alertsLinkText', {
      defaultMessage: 'Alerts'
    }),
    href: http.basePath.prepend('/app/observability/alerts'),
    deepLinkId: 'observability-overview:alerts'
  }, {
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.rulesLinkText', {
      defaultMessage: 'Rules'
    })
  }]);
  const filteredRuleTypes = (0, _use_get_filtered_rule_types.useGetFilteredRuleTypes)();
  const {
    ruleTypesState: {
      data: ruleTypes
    }
  } = (0, _public2.useLoadRuleTypesQuery)({
    filteredRuleTypes
  });
  const authorizedRuleTypes = [...ruleTypes.values()];
  const authorizedToCreateAnyRules = authorizedRuleTypes.some(ruleType => {
    var _ruleType$authorizedC;
    return (_ruleType$authorizedC = ruleType.authorizedConsumers[_common.ALERTS_FEATURE_ID]) === null || _ruleType$authorizedC === void 0 ? void 0 : _ruleType$authorizedC.all;
  });
  const tabs = [{
    name: 'rules',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.rulePage.rulesTabTitle",
      defaultMessage: "Rules"
    }),
    onClick: () => history.push(_paths.RULES_PATH),
    isSelected: activeTab === RULES_TAB_NAME
  }, {
    name: 'logs',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.rulePage.logsTabTitle",
      defaultMessage: "Logs"
    }),
    onClick: () => history.push(_paths.RULES_LOGS_PATH),
    ['data-test-subj']: 'ruleLogsTab',
    isSelected: activeTab !== RULES_TAB_NAME
  }];
  const rightSideItems = [...(activeTab === RULES_TAB_NAME ? [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "createRuleButton",
    disabled: !authorizedToCreateAnyRules,
    fill: true,
    iconType: "plusInCircle",
    key: "create-alert",
    onClick: () => setAddRuleFlyoutVisibility(true)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.rules.addRuleButtonLabel",
    defaultMessage: "Create rule"
  }))] : []), /*#__PURE__*/_react.default.createElement(RulesSettingsLink, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "documentationLink",
    href: docLinks.links.observability.createAlerts,
    iconType: "help",
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.rules.docsLinkText",
    defaultMessage: "Documentation"
  }))];
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    pageHeader: {
      pageTitle: _i18n.i18n.translate('xpack.observability.rulesTitle', {
        defaultMessage: 'Rules'
      }),
      rightSideItems,
      tabs
    },
    "data-test-subj": "rulesPage"
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, activeTab === RULES_TAB_NAME ? /*#__PURE__*/_react.default.createElement(_rules_tab.RulesTab, {
    setRefresh: setRefresh,
    stateRefresh: stateRefresh
  }) : /*#__PURE__*/_react.default.createElement(GlobalLogsTab, null))), addRuleFlyoutVisibility && /*#__PURE__*/_react.default.createElement(AddRuleFlyout, {
    consumer: _common.ALERTS_FEATURE_ID,
    filteredRuleTypes: filteredRuleTypes,
    validConsumers: _constants.observabilityRuleCreationValidConsumers,
    initialSelectedConsumer: _ruleDataUtils.AlertConsumers.LOGS,
    onClose: () => {
      setAddRuleFlyoutVisibility(false);
    },
    onSave: () => {
      setRefresh(new Date());
      return Promise.resolve();
    },
    hideGrouping: true,
    useRuleProducer: true
  }));
}