"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatePicker = DatePicker;
exports.default = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana_ui_settings = require("../../../../hooks/use_kibana_ui_settings");
var _use_date_picker_context = require("../../../../hooks/use_date_picker_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DatePicker({
  rangeFrom,
  rangeTo,
  refreshPaused,
  refreshInterval,
  width = 'restricted',
  onTimeRangeRefresh
}) {
  const {
    updateTimeRange,
    updateRefreshInterval
  } = (0, _use_date_picker_context.useDatePickerContext)();
  const timePickerQuickRanges = (0, _use_kibana_ui_settings.useKibanaUISettings)(_use_kibana_ui_settings.UI_SETTINGS.TIMEPICKER_QUICK_RANGES);
  const commonlyUsedRanges = timePickerQuickRanges.map(({
    from,
    to,
    display
  }) => ({
    start: from,
    end: to,
    label: display
  }));
  function onRefreshChange({
    isPaused,
    refreshInterval: interval
  }) {
    updateRefreshInterval({
      isPaused,
      interval
    });
  }
  const onRefresh = (0, _react.useCallback)(newRange => {
    if (onTimeRangeRefresh) {
      onTimeRangeRefresh(newRange);
    }
    updateTimeRange(newRange);
  }, [onTimeRangeRefresh, updateTimeRange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: rangeFrom,
    end: rangeTo,
    onTimeChange: onRefresh,
    onRefresh: onRefresh,
    isPaused: refreshPaused,
    refreshInterval: refreshInterval,
    onRefreshChange: onRefreshChange,
    commonlyUsedRanges: commonlyUsedRanges,
    width: width
  });
}

// eslint-disable-next-line import/no-default-export
var _default = DatePicker;
exports.default = _default;