"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloDeleteConfirmationModal = SloDeleteConfirmationModal;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloDeleteConfirmationModal({
  slo,
  onCancel,
  onConfirm
}) {
  const {
    name,
    groupBy
  } = slo;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    buttonColor: "danger",
    "data-test-subj": "sloDeleteConfirmationModal",
    title: _i18n.i18n.translate('xpack.observability.slo.deleteConfirmationModal.title', {
      defaultMessage: 'Delete {name}?',
      values: {
        name
      }
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.observability.slo.deleteConfirmationModal.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.observability.slo.deleteConfirmationModal.deleteButtonLabel', {
      defaultMessage: 'Delete'
    }),
    onCancel: onCancel,
    onConfirm: onConfirm
  }, groupBy !== _sloSchema.ALL_VALUE ? _i18n.i18n.translate('xpack.observability.slo.deleteConfirmationModal.groupByDisclaimerText', {
    defaultMessage: 'This SLO has been generated with a group key on "{groupKey}". Deleting this SLO definition will result in all instances being deleted.',
    values: {
      groupKey: groupBy
    }
  }) : _i18n.i18n.translate('xpack.observability.slo.deleteConfirmationModal.descriptionText', {
    defaultMessage: "You can't recover this SLO after deleting it."
  }));
}