"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExpressionChartData = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _react = require("react");
var _types = require("../../../../common/custom_threshold_rule/types");
var _use_expression_data = require("./use_expression_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_TIME_RANGE = {};
const DEFAULT_TIMESTAMP = '@timestamp';
const useExpressionChartData = (expression, derivedIndexPattern, filterQuery, groupBy, timeRange = DEFAULT_TIME_RANGE, timeFieldName = DEFAULT_TIMESTAMP) => {
  const {
    timeSize,
    timeUnit
  } = expression || {
    timeSize: 1,
    timeUnit: 'm'
  };
  const options = (0, _react.useMemo)(() => {
    var _expression$metrics$m, _expression$metrics;
    return {
      limit: 1,
      forceInterval: true,
      dropLastBucket: false,
      groupBy,
      filterQuery,
      metrics: [{
        aggregation: 'custom',
        // Infra API expects this field to be custom_metrics
        // since the same field is used in the metric threshold rule
        custom_metrics: (_expression$metrics$m = expression === null || expression === void 0 ? void 0 : (_expression$metrics = expression.metrics) === null || _expression$metrics === void 0 ? void 0 : _expression$metrics.map(mapCustomThresholdMetricToMetricsExplorerMetric)) !== null && _expression$metrics$m !== void 0 ? _expression$metrics$m : [],
        equation: expression.equation
      }],
      aggregation: 'custom'
    };
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [expression.equation,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  JSON.stringify(expression.metrics), filterQuery, groupBy]);
  const timestamps = (0, _react.useMemo)(() => {
    var _timeRange$from, _timeRange$to;
    const from = (_timeRange$from = timeRange.from) !== null && _timeRange$from !== void 0 ? _timeRange$from : `now-${(timeSize || 1) * 20}${timeUnit}`;
    const to = (_timeRange$to = timeRange.to) !== null && _timeRange$to !== void 0 ? _timeRange$to : 'now';
    const fromTimestamp = _datemath.default.parse(from).valueOf();
    const toTimestamp = _datemath.default.parse(to, {
      roundUp: true
    }).valueOf();
    return {
      interval: `>=${timeSize || 1}${timeUnit}`,
      fromTimestamp,
      toTimestamp,
      timeFieldName
    };
  }, [timeRange.from, timeRange.to, timeSize, timeUnit, timeFieldName]);
  return (0, _use_expression_data.useExpressionData)(options, derivedIndexPattern, timestamps);
};
exports.useExpressionChartData = useExpressionChartData;
const mapCustomThresholdMetricToMetricsExplorerMetric = metric => {
  if (metric.aggType === 'count') {
    return {
      name: metric.name,
      aggregation: _types.Aggregators.COUNT,
      filter: metric.filter
    };
  }
  return {
    name: metric.name,
    aggregation: metric.aggType,
    field: metric.field
  };
};